/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.auth;

import java.net.Socket;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAuthUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HiveAuthUtils.class);

    public static TTransport getSocketTransport(String host, int port, int loginTimeout) {
        return new TSocket(host, port, loginTimeout);
    }

    public static TTransport getSSLSocket(String host, int port, int loginTimeout) throws TTransportException {
        TSocket tSSLSocket = TSSLTransportFactory.getClientSocket((String)host, (int)port, (int)loginTimeout);
        return HiveAuthUtils.getSSLSocketWithHttps(tSSLSocket);
    }

    public static TTransport getSSLSocket(String host, int port, int loginTimeout, String trustStorePath, String trustStorePassWord) throws TTransportException {
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        params.setTrustStore(trustStorePath, trustStorePassWord);
        params.requireClientAuth(true);
        TSocket tSSLSocket = TSSLTransportFactory.getClientSocket((String)host, (int)port, (int)loginTimeout, (TSSLTransportFactory.TSSLTransportParameters)params);
        return HiveAuthUtils.getSSLSocketWithHttps(tSSLSocket);
    }

    public static TTransport getTLSClientSocket(String host, int port, int loginTimeout, String trustStorePath, String trustStorePassWord) throws TTransportException {
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        params.setTrustStore(trustStorePath, trustStorePassWord);
        return TSSLTransportFactory.getClientSocket((String)host, (int)port, (int)loginTimeout, (TSSLTransportFactory.TSSLTransportParameters)params);
    }

    public static TTransport get2WayTLSClientSocket(String host, int port, int loginTimeout, String trustStorePath, String trustStorePassword, String keyStorePath, String keyStorePassword) throws TTransportException {
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        params.setTrustStore(trustStorePath, trustStorePassword);
        params.setKeyStore(keyStorePath, keyStorePassword);
        return TSSLTransportFactory.getClientSocket((String)host, (int)port, (int)loginTimeout, (TSSLTransportFactory.TSSLTransportParameters)params);
    }

    private static TSocket getSSLSocketWithHttps(TSocket tSSLSocket) throws TTransportException {
        SSLSocket sslSocket = (SSLSocket)tSSLSocket.getSocket();
        SSLParameters sslParams = sslSocket.getSSLParameters();
        sslParams.setEndpointIdentificationAlgorithm("HTTPS");
        sslSocket.setSSLParameters(sslParams);
        return new TSocket((Socket)sslSocket);
    }
}

