/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.auth;

import io.hops.security.HopsFileBasedKeyStoresFactory;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.auth.HiveAuthUtils;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HopsTLSTSocketFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HiveAuthUtils.class);

    public static TServerSocket getServerSocket(Configuration conf, HopsTLSTransportParams params) throws TTransportException {
        SSLContext ctx = HopsTLSTSocketFactory.createSSLContext(conf, params);
        return HopsTLSTSocketFactory.createServer(ctx.getServerSocketFactory(), params);
    }

    private static SSLContext createSSLContext(Configuration conf, HopsTLSTransportParams params) throws TTransportException {
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLS");
            HopsFileBasedKeyStoresFactory keyStoresFactory = new HopsFileBasedKeyStoresFactory();
            keyStoresFactory.setConf(conf);
            keyStoresFactory.setSystemConf(conf);
            keyStoresFactory.init(SSLFactory.Mode.SERVER);
            ctx.init(keyStoresFactory.getKeyManagers(), keyStoresFactory.getTrustManagers(), null);
            ctx.getDefaultSSLParameters().setProtocols(params.enabledProtocols);
        }
        catch (Exception var17) {
            throw new TTransportException("Error creating the transport", (Throwable)var17);
        }
        return ctx;
    }

    private static TServerSocket createServer(SSLServerSocketFactory factory, HopsTLSTransportParams params) throws TTransportException {
        try {
            SSLServerSocket serverSocket = (SSLServerSocket)factory.createServerSocket(params.ifAddress.getPort(), 100, params.ifAddress.getAddress());
            serverSocket.setSoTimeout(params.clientTimeout);
            serverSocket.setNeedClientAuth(params.clientAuth);
            HopsTLSTSocketFactory.disableExcludedCiphers(serverSocket, params);
            return new TServerSocket(new TServerSocket.ServerSocketTransportArgs().serverSocket((ServerSocket)serverSocket));
        }
        catch (Exception var7) {
            throw new TTransportException("Could not bind to port " + params.ifAddress.getPort(), (Throwable)var7);
        }
    }

    private static void disableExcludedCiphers(SSLServerSocket sslServerSocket, HopsTLSTransportParams params) {
        String[] cipherSuites = sslServerSocket.getEnabledCipherSuites();
        ArrayList<String> defaultEnabledCipherSuites = new ArrayList<String>(Arrays.asList(cipherSuites));
        for (String cipherName : params.excludeCiphers) {
            if (!defaultEnabledCipherSuites.contains(cipherName)) continue;
            defaultEnabledCipherSuites.remove(cipherName);
            LOG.debug("Disabling cipher suite {}.", (Object)cipherName);
        }
        cipherSuites = defaultEnabledCipherSuites.toArray(new String[defaultEnabledCipherSuites.size()]);
        sslServerSocket.setEnabledCipherSuites(cipherSuites);
    }

    public static class HopsTLSTransportParams {
        protected int clientTimeout;
        protected InetSocketAddress ifAddress;
        protected List<String> excludeCiphers;
        protected String[] enabledProtocols;
        protected boolean clientAuth;
    }
}

