/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.contrib.util.typedbytes;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.contrib.util.typedbytes.Type;
import org.apache.hadoop.hive.contrib.util.typedbytes.TypedBytesInput;
import org.apache.hadoop.hive.contrib.util.typedbytes.TypedBytesWritable;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SortedMapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.VIntWritable;
import org.apache.hadoop.io.VLongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.util.ReflectionUtils;

public class TypedBytesWritableInput
implements Configurable {
    private TypedBytesInput in;
    private Configuration conf = new Configuration();
    private static ThreadLocal tbIn = new ThreadLocal(){

        protected Object initialValue() {
            return new TypedBytesWritableInput();
        }
    };

    private TypedBytesWritableInput() {
    }

    private void setTypedBytesInput(TypedBytesInput in) {
        this.in = in;
    }

    public static TypedBytesWritableInput get(TypedBytesInput in) {
        TypedBytesWritableInput bin = (TypedBytesWritableInput)tbIn.get();
        bin.setTypedBytesInput(in);
        return bin;
    }

    public static TypedBytesWritableInput get(DataInput in) {
        return TypedBytesWritableInput.get(TypedBytesInput.get(in));
    }

    public TypedBytesWritableInput(TypedBytesInput in) {
        this();
        this.in = in;
    }

    public TypedBytesWritableInput(DataInput din) {
        this(new TypedBytesInput(din));
    }

    public Writable read() throws IOException {
        Type type = this.in.readType();
        if (type == null) {
            return null;
        }
        switch (type) {
            case BYTES: {
                return this.readBytes();
            }
            case BYTE: {
                return this.readByte();
            }
            case BOOL: {
                return this.readBoolean();
            }
            case INT: {
                return this.readVInt();
            }
            case SHORT: {
                return this.readShort();
            }
            case LONG: {
                return this.readVLong();
            }
            case FLOAT: {
                return this.readFloat();
            }
            case DOUBLE: {
                return this.readDouble();
            }
            case STRING: {
                return this.readText();
            }
            case VECTOR: {
                return this.readArray();
            }
            case MAP: {
                return this.readMap();
            }
            case WRITABLE: {
                return this.readWritable();
            }
            case ENDOFRECORD: {
                return null;
            }
            case NULL: {
                return NullWritable.get();
            }
        }
        throw new RuntimeException("unknown type");
    }

    public Type readTypeCode() throws IOException {
        return this.in.readType();
    }

    public Class<? extends Writable> readType() throws IOException {
        Type type = this.in.readType();
        if (type == null) {
            return null;
        }
        switch (type) {
            case BYTES: {
                return BytesWritable.class;
            }
            case BYTE: {
                return ByteWritable.class;
            }
            case BOOL: {
                return BooleanWritable.class;
            }
            case INT: {
                return VIntWritable.class;
            }
            case LONG: {
                return VLongWritable.class;
            }
            case FLOAT: {
                return FloatWritable.class;
            }
            case SHORT: {
                return ShortWritable.class;
            }
            case DOUBLE: {
                return DoubleWritable.class;
            }
            case STRING: {
                return Text.class;
            }
            case VECTOR: {
                return ArrayWritable.class;
            }
            case MAP: {
                return MapWritable.class;
            }
            case WRITABLE: {
                return Writable.class;
            }
            case ENDOFRECORD: {
                return null;
            }
            case NULL: {
                return NullWritable.class;
            }
        }
        throw new RuntimeException("unknown type");
    }

    public BytesWritable readBytes(BytesWritable bw) throws IOException {
        byte[] bytes = this.in.readBytes();
        if (bw == null) {
            bw = new BytesWritable(bytes);
        } else {
            bw.set(bytes, 0, bytes.length);
        }
        return bw;
    }

    public BytesWritable readBytes() throws IOException {
        return this.readBytes(null);
    }

    public ByteWritable readByte(ByteWritable bw) throws IOException {
        if (bw == null) {
            bw = new ByteWritable();
        }
        bw.set(this.in.readByte());
        return bw;
    }

    public ByteWritable readByte() throws IOException {
        return this.readByte(null);
    }

    public BooleanWritable readBoolean(BooleanWritable bw) throws IOException {
        if (bw == null) {
            bw = new BooleanWritable();
        }
        bw.set(this.in.readBool());
        return bw;
    }

    public BooleanWritable readBoolean() throws IOException {
        return this.readBoolean(null);
    }

    public IntWritable readInt(IntWritable iw) throws IOException {
        if (iw == null) {
            iw = new IntWritable();
        }
        iw.set(this.in.readInt());
        return iw;
    }

    public IntWritable readInt() throws IOException {
        return this.readInt(null);
    }

    public ShortWritable readShort(ShortWritable sw) throws IOException {
        if (sw == null) {
            sw = new ShortWritable();
        }
        sw.set(this.in.readShort());
        return sw;
    }

    public ShortWritable readShort() throws IOException {
        return this.readShort(null);
    }

    public VIntWritable readVInt(VIntWritable iw) throws IOException {
        if (iw == null) {
            iw = new VIntWritable();
        }
        iw.set(this.in.readInt());
        return iw;
    }

    public VIntWritable readVInt() throws IOException {
        return this.readVInt(null);
    }

    public LongWritable readLong(LongWritable lw) throws IOException {
        if (lw == null) {
            lw = new LongWritable();
        }
        lw.set(this.in.readLong());
        return lw;
    }

    public LongWritable readLong() throws IOException {
        return this.readLong(null);
    }

    public VLongWritable readVLong(VLongWritable lw) throws IOException {
        if (lw == null) {
            lw = new VLongWritable();
        }
        lw.set(this.in.readLong());
        return lw;
    }

    public VLongWritable readVLong() throws IOException {
        return this.readVLong(null);
    }

    public FloatWritable readFloat(FloatWritable fw) throws IOException {
        if (fw == null) {
            fw = new FloatWritable();
        }
        fw.set(this.in.readFloat());
        return fw;
    }

    public FloatWritable readFloat() throws IOException {
        return this.readFloat(null);
    }

    public DoubleWritable readDouble(DoubleWritable dw) throws IOException {
        if (dw == null) {
            dw = new DoubleWritable();
        }
        dw.set(this.in.readDouble());
        return dw;
    }

    public DoubleWritable readDouble() throws IOException {
        return this.readDouble(null);
    }

    public Text readText(Text t) throws IOException {
        if (t == null) {
            t = new Text();
        }
        t.set(this.in.readString());
        return t;
    }

    public Text readText() throws IOException {
        return this.readText(null);
    }

    public ArrayWritable readArray(ArrayWritable aw) throws IOException {
        if (aw == null) {
            aw = new ArrayWritable(TypedBytesWritable.class);
        } else if (!aw.getValueClass().equals(TypedBytesWritable.class)) {
            throw new RuntimeException("value class has to be TypedBytesWritable");
        }
        int length = this.in.readVectorHeader();
        Writable[] writables = new Writable[length];
        for (int i = 0; i < length; ++i) {
            writables[i] = new TypedBytesWritable(this.in.readRaw());
        }
        aw.set(writables);
        return aw;
    }

    public ArrayWritable readArray() throws IOException {
        return this.readArray(null);
    }

    public MapWritable readMap(MapWritable mw) throws IOException {
        if (mw == null) {
            mw = new MapWritable();
        }
        int length = this.in.readMapHeader();
        for (int i = 0; i < length; ++i) {
            Writable key = this.read();
            Writable value = this.read();
            mw.put(key, value);
        }
        return mw;
    }

    public MapWritable readMap() throws IOException {
        return this.readMap(null);
    }

    public SortedMapWritable readSortedMap(SortedMapWritable mw) throws IOException {
        if (mw == null) {
            mw = new SortedMapWritable();
        }
        int length = this.in.readMapHeader();
        for (int i = 0; i < length; ++i) {
            WritableComparable key = (WritableComparable)this.read();
            Writable value = this.read();
            mw.put(key, value);
        }
        return mw;
    }

    public SortedMapWritable readSortedMap() throws IOException {
        return this.readSortedMap(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writable readWritable(Writable writable) throws IOException {
        Writable writable2;
        DataInputStream dis = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.in.readBytes());
            dis = new DataInputStream(bais);
            String className = WritableUtils.readString((DataInput)dis);
            if (writable == null) {
                try {
                    Class<Writable> cls = this.conf.getClassByName(className).asSubclass(Writable.class);
                    writable = (Writable)ReflectionUtils.newInstance(cls, (Configuration)this.conf);
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
            } else if (!writable.getClass().getName().equals(className)) {
                throw new IOException("wrong Writable class given");
            }
            writable.readFields((DataInput)dis);
            dis.close();
            dis = null;
            writable2 = writable;
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(dis);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)dis);
        return writable2;
    }

    public Writable readWritable() throws IOException {
        return this.readWritable(null);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }
}

