/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.json;

import java.io.File;
import org.apache.hadoop.hive.druid.json.KafkaTuningConfig;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.joda.time.Duration;
import org.joda.time.Period;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="kafka", value=KafkaSupervisorTuningConfig.class)})
public class KafkaSupervisorTuningConfig
extends KafkaTuningConfig {
    private final Integer workerThreads;
    private final Integer chatThreads;
    private final Long chatRetries;
    private final Duration httpTimeout;
    private final Duration shutdownTimeout;
    private final Duration offsetFetchPeriod;

    public KafkaSupervisorTuningConfig(@JsonProperty(value="maxRowsInMemory") Integer maxRowsInMemory, @JsonProperty(value="maxRowsPerSegment") Integer maxRowsPerSegment, @JsonProperty(value="intermediatePersistPeriod") Period intermediatePersistPeriod, @JsonProperty(value="basePersistDirectory") File basePersistDirectory, @JsonProperty(value="maxPendingPersists") Integer maxPendingPersists, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="buildV9Directly") Boolean buildV9Directly, @JsonProperty(value="reportParseExceptions") Boolean reportParseExceptions, @JsonProperty(value="handoffConditionTimeout") Long handoffConditionTimeout, @JsonProperty(value="resetOffsetAutomatically") Boolean resetOffsetAutomatically, @JsonProperty(value="workerThreads") Integer workerThreads, @JsonProperty(value="chatThreads") Integer chatThreads, @JsonProperty(value="chatRetries") Long chatRetries, @JsonProperty(value="httpTimeout") Period httpTimeout, @JsonProperty(value="shutdownTimeout") Period shutdownTimeout, @JsonProperty(value="offsetFetchPeriod") Period offsetFetchPeriod) {
        super(maxRowsInMemory, maxRowsPerSegment, intermediatePersistPeriod, basePersistDirectory, maxPendingPersists, indexSpec, true, reportParseExceptions, handoffConditionTimeout, resetOffsetAutomatically);
        this.workerThreads = workerThreads;
        this.chatThreads = chatThreads;
        this.chatRetries = chatRetries != null ? chatRetries : 8L;
        this.httpTimeout = KafkaSupervisorTuningConfig.defaultDuration(httpTimeout, "PT10S");
        this.shutdownTimeout = KafkaSupervisorTuningConfig.defaultDuration(shutdownTimeout, "PT80S");
        this.offsetFetchPeriod = KafkaSupervisorTuningConfig.defaultDuration(offsetFetchPeriod, "PT30S");
    }

    @JsonProperty
    public Integer getWorkerThreads() {
        return this.workerThreads;
    }

    @JsonProperty
    public Integer getChatThreads() {
        return this.chatThreads;
    }

    @JsonProperty
    public Long getChatRetries() {
        return this.chatRetries;
    }

    @JsonProperty
    public Duration getHttpTimeout() {
        return this.httpTimeout;
    }

    @JsonProperty
    public Duration getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    @JsonProperty
    public Duration getOffsetFetchPeriod() {
        return this.offsetFetchPeriod;
    }

    @Override
    public String toString() {
        return "KafkaSupervisorTuningConfig{maxRowsInMemory=" + this.getMaxRowsInMemory() + ", maxRowsPerSegment=" + this.getMaxRowsPerSegment() + ", intermediatePersistPeriod=" + this.getIntermediatePersistPeriod() + ", basePersistDirectory=" + this.getBasePersistDirectory() + ", maxPendingPersists=" + this.getMaxPendingPersists() + ", indexSpec=" + this.getIndexSpec() + ", reportParseExceptions=" + this.isReportParseExceptions() + ", handoffConditionTimeout=" + this.getHandoffConditionTimeout() + ", resetOffsetAutomatically=" + this.isResetOffsetAutomatically() + ", workerThreads=" + this.workerThreads + ", chatThreads=" + this.chatThreads + ", chatRetries=" + this.chatRetries + ", httpTimeout=" + this.httpTimeout + ", shutdownTimeout=" + this.shutdownTimeout + ", offsetFetchPeriod=" + this.offsetFetchPeriod + '}';
    }

    private static Duration defaultDuration(Period period, String theDefault) {
        return (period == null ? new Period((Object)theDefault) : period).toStandardDuration();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaSupervisorTuningConfig that = (KafkaSupervisorTuningConfig)o;
        if (this.workerThreads != null ? !this.workerThreads.equals(that.workerThreads) : that.workerThreads != null) {
            return false;
        }
        if (this.chatThreads != null ? !this.chatThreads.equals(that.chatThreads) : that.chatThreads != null) {
            return false;
        }
        if (this.chatRetries != null ? !this.chatRetries.equals(that.chatRetries) : that.chatRetries != null) {
            return false;
        }
        if (this.httpTimeout != null ? !this.httpTimeout.equals((Object)that.httpTimeout) : that.httpTimeout != null) {
            return false;
        }
        if (this.shutdownTimeout != null ? !this.shutdownTimeout.equals((Object)that.shutdownTimeout) : that.shutdownTimeout != null) {
            return false;
        }
        return this.offsetFetchPeriod != null ? this.offsetFetchPeriod.equals((Object)that.offsetFetchPeriod) : that.offsetFetchPeriod == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.workerThreads != null ? this.workerThreads.hashCode() : 0);
        result = 31 * result + (this.chatThreads != null ? this.chatThreads.hashCode() : 0);
        result = 31 * result + (this.chatRetries != null ? this.chatRetries.hashCode() : 0);
        result = 31 * result + (this.httpTimeout != null ? this.httpTimeout.hashCode() : 0);
        result = 31 * result + (this.shutdownTimeout != null ? this.shutdownTimeout.hashCode() : 0);
        result = 31 * result + (this.offsetFetchPeriod != null ? this.offsetFetchPeriod.hashCode() : 0);
        return result;
    }
}

