/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class DruidDataSource {
    private final String name;
    private final Map<String, String> properties;
    private final ConcurrentHashMap<String, DataSegment> idToSegmentMap;

    public DruidDataSource(String name, Map<String, String> properties) {
        this.name = Preconditions.checkNotNull(name);
        this.properties = properties;
        this.idToSegmentMap = new ConcurrentHashMap();
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Collection<DataSegment> getSegments() {
        return Collections.unmodifiableCollection(this.idToSegmentMap.values());
    }

    public DruidDataSource addSegment(DataSegment dataSegment) {
        this.idToSegmentMap.put(dataSegment.getIdentifier(), dataSegment);
        return this;
    }

    public DruidDataSource removePartition(String segmentId) {
        this.idToSegmentMap.remove(segmentId);
        return this;
    }

    public DataSegment getSegment(String identifier) {
        return this.idToSegmentMap.get(identifier);
    }

    public boolean isEmpty() {
        return this.idToSegmentMap.isEmpty();
    }

    public ImmutableDruidDataSource toImmutableDruidDataSource() {
        return new ImmutableDruidDataSource(this.name, ImmutableMap.copyOf(this.properties), ImmutableMap.copyOf(this.idToSegmentMap));
    }

    public String toString() {
        return "DruidDataSource{properties=" + this.properties + ", partitions=" + this.idToSegmentMap.values() + '}';
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("Use ImmutableDruidDataSource instead");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Use ImmutableDruidDataSource instead");
    }
}

