/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.extendedset.intset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hive.druid.io.druid.extendedset.intset.IntSet;

public abstract class AbstractIntSet
implements IntSet {
    @Override
    public IntSet union(IntSet other) {
        IntSet res = this.clone();
        res.addAll(other);
        return res;
    }

    @Override
    public IntSet difference(IntSet other) {
        IntSet res = this.clone();
        res.removeAll(other);
        return res;
    }

    @Override
    public IntSet intersection(IntSet other) {
        IntSet res = this.clone();
        res.retainAll(other);
        return res;
    }

    @Override
    public IntSet symmetricDifference(IntSet c) {
        IntSet res = this.clone();
        IntSet.IntIterator itr = c.iterator();
        while (itr.hasNext()) {
            res.flip(itr.next());
        }
        return res;
    }

    @Override
    public IntSet complemented() {
        IntSet res = this.clone();
        res.complement();
        return res;
    }

    @Override
    public void complement() {
        if (this.isEmpty()) {
            return;
        }
        for (int e = this.last(); e >= 0; --e) {
            this.flip(e);
        }
    }

    @Override
    public boolean containsAll(IntSet c) {
        IntSet.IntIterator itr = c.iterator();
        boolean res = true;
        while (res && itr.hasNext()) {
            res = this.contains(itr.next());
        }
        return res;
    }

    @Override
    public boolean containsAny(IntSet c) {
        IntSet.IntIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (!this.contains(itr.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(IntSet c, int minElements) {
        IntSet.IntIterator itr = c.iterator();
        while (minElements > 0 && itr.hasNext()) {
            if (!this.contains(itr.next())) continue;
            --minElements;
        }
        return minElements == 0;
    }

    @Override
    public int intersectionSize(IntSet c) {
        int res = 0;
        IntSet.IntIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (!this.contains(itr.next())) continue;
            ++res;
        }
        return res;
    }

    @Override
    public int unionSize(IntSet other) {
        return other == null ? this.size() : this.size() + other.size() - this.intersectionSize(other);
    }

    @Override
    public int symmetricDifferenceSize(IntSet other) {
        return other == null ? this.size() : this.size() + other.size() - 2 * this.intersectionSize(other);
    }

    @Override
    public int differenceSize(IntSet other) {
        return other == null ? this.size() : this.size() - this.intersectionSize(other);
    }

    @Override
    public int complementSize() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.last() - this.size() + 1;
    }

    @Override
    public abstract IntSet empty();

    @Override
    public abstract IntSet clone();

    @Override
    public abstract double bitmapCompressionRatio();

    @Override
    public abstract double collectionCompressionRatio();

    @Override
    public abstract IntSet.IntIterator iterator();

    @Override
    public abstract IntSet.IntIterator descendingIterator();

    @Override
    public abstract String debugInfo();

    @Override
    public void clear() {
        IntSet.IntIterator itr = this.iterator();
        while (itr.hasNext()) {
            itr.next();
            itr.remove();
        }
    }

    @Override
    public void clear(int from, int to) {
        if (from > to) {
            throw new IndexOutOfBoundsException("from: " + from + " > to: " + to);
        }
        for (int e = from; e <= to; ++e) {
            this.remove(e);
        }
    }

    @Override
    public void fill(int from, int to) {
        if (from > to) {
            throw new IndexOutOfBoundsException("from: " + from + " > to: " + to);
        }
        for (int e = from; e <= to; ++e) {
            this.add(e);
        }
    }

    @Override
    public void flip(int e) {
        if (!this.add(e)) {
            this.remove(e);
        }
    }

    @Override
    public abstract int get(int var1);

    @Override
    public abstract int indexOf(int var1);

    @Override
    public abstract IntSet convert(int ... var1);

    @Override
    public abstract IntSet convert(Collection<Integer> var1);

    @Override
    public int first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.iterator().next();
    }

    @Override
    public abstract int last();

    @Override
    public abstract int size();

    @Override
    public abstract boolean isEmpty();

    @Override
    public abstract boolean contains(int var1);

    @Override
    public abstract boolean add(int var1);

    @Override
    public abstract boolean remove(int var1);

    @Override
    public boolean addAll(IntSet c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        IntSet.IntIterator itr = c.iterator();
        boolean res = false;
        while (itr.hasNext()) {
            res |= this.add(itr.next());
        }
        return res;
    }

    @Override
    public boolean removeAll(IntSet c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        IntSet.IntIterator itr = c.iterator();
        boolean res = false;
        while (itr.hasNext()) {
            res |= this.remove(itr.next());
        }
        return res;
    }

    @Override
    public boolean retainAll(IntSet c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        IntSet.IntIterator itr = this.iterator();
        boolean res = false;
        while (itr.hasNext()) {
            int e = itr.next();
            if (c.contains(e)) continue;
            res = true;
            itr.remove();
        }
        return res;
    }

    @Override
    public int[] toArray() {
        if (this.isEmpty()) {
            return null;
        }
        return this.toArray(new int[this.size()]);
    }

    @Override
    public int[] toArray(int[] a) {
        if (a.length < this.size()) {
            a = new int[this.size()];
        }
        IntSet.IntIterator itr = this.iterator();
        int i = 0;
        while (itr.hasNext()) {
            a[i++] = itr.next();
        }
        while (i < a.length) {
            a[i] = 0;
            ++i;
        }
        return a;
    }

    public String toString() {
        IntSet.IntIterator itr = this.iterator();
        if (!itr.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            int e = itr.next();
            sb.append(e);
            if (!itr.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }

    @Override
    public int compareTo(IntSet o) {
        IntSet.IntIterator thisIterator = this.descendingIterator();
        IntSet.IntIterator otherIterator = o.descendingIterator();
        while (thisIterator.hasNext() && otherIterator.hasNext()) {
            int otherItem;
            int thisItem = thisIterator.next();
            if (thisItem < (otherItem = otherIterator.next())) {
                return -1;
            }
            if (thisItem <= otherItem) continue;
            return 1;
        }
        return thisIterator.hasNext() ? 1 : (otherIterator.hasNext() ? -1 : 0);
    }

    @Override
    public List<? extends IntSet> powerSet() {
        return this.powerSet(1, Integer.MAX_VALUE);
    }

    @Override
    public List<? extends IntSet> powerSet(int min, int max) {
        if (min < 1 || max < min) {
            throw new IllegalArgumentException();
        }
        ArrayList<IntSet> res = new ArrayList<IntSet>();
        if (this.size() < min) {
            return res;
        }
        if (this.size() == min) {
            res.add(this.clone());
            return res;
        }
        if (this.size() == min + 1) {
            IntSet.IntIterator itr = this.descendingIterator();
            while (itr.hasNext()) {
                IntSet set = this.clone();
                set.remove(itr.next());
                res.add(set);
            }
            if (max > min) {
                res.add(this.clone());
            }
            return res;
        }
        ArrayList level = new ArrayList();
        level.add(new ArrayList());
        IntSet.IntIterator itr = this.iterator();
        while (itr.hasNext()) {
            IntSet single = this.empty();
            single.add(itr.next());
            ((List)level.get(0)).add(single);
        }
        if (min == 1) {
            res.addAll((Collection)level.get(0));
        }
        for (int lvl = 2; !level.isEmpty() && lvl <= max; ++lvl) {
            ArrayList newLevel = new ArrayList();
            for (List list : level) {
                for (int i = 0; i < list.size() - 1; ++i) {
                    ArrayList<IntSet> newPrefix = new ArrayList<IntSet>();
                    for (int j = i + 1; j < list.size(); ++j) {
                        IntSet x = ((IntSet)list.get(i)).clone();
                        x.add(((IntSet)list.get(j)).last());
                        newPrefix.add(x);
                        if (lvl < min) continue;
                        res.add(x);
                    }
                    if (newPrefix.size() <= 1) continue;
                    newLevel.add(newPrefix);
                }
            }
            level = newLevel;
        }
        return res;
    }

    @Override
    public int powerSetSize() {
        return this.isEmpty() ? 0 : (int)Math.pow(2.0, this.size()) - 1;
    }

    @Override
    public double jaccardSimilarity(IntSet other) {
        if (this.isEmpty() && other.isEmpty()) {
            return 1.0;
        }
        int inters = this.intersectionSize(other);
        return (double)inters / (double)(this.size() + other.size() - inters);
    }

    @Override
    public double jaccardDistance(IntSet other) {
        return 1.0 - this.jaccardSimilarity(other);
    }

    @Override
    public double weightedJaccardSimilarity(IntSet other) {
        if (this.isEmpty() && other.isEmpty()) {
            return 1.0;
        }
        IntSet.IntIterator itr = this.intersection(other).iterator();
        double intersectionSum = 0.0;
        while (itr.hasNext()) {
            intersectionSum += (double)itr.next();
        }
        itr = this.symmetricDifference(other).iterator();
        double symmetricDifferenceSum = 0.0;
        while (itr.hasNext()) {
            symmetricDifferenceSum += (double)itr.next();
        }
        return intersectionSum / (intersectionSum + symmetricDifferenceSum);
    }

    @Override
    public double weightedJaccardDistance(IntSet other) {
        return 1.0 - this.weightedJaccardSimilarity(other);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntSet)) {
            return false;
        }
        if (this.size() != ((IntSet)obj).size()) {
            return false;
        }
        IntSet.IntIterator itr1 = this.iterator();
        IntSet.IntIterator itr2 = ((IntSet)obj).iterator();
        while (itr1.hasNext()) {
            if (itr1.next() == itr2.next()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        int h = 1;
        IntSet.IntIterator itr = this.iterator();
        if (!itr.hasNext()) {
            h = (h << 5) - h + itr.next();
        }
        return h;
    }
}

