/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.extendedset.utilities;

import java.nio.IntBuffer;
import java.util.ArrayList;

public class IntList {
    private static final int ALLOCATION_SIZE = 1024;
    private final ArrayList<int[]> baseLists = new ArrayList();
    private int maxIndex = -1;

    public int length() {
        return this.maxIndex + 1;
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public void add(int value) {
        this.set(this.length(), value);
    }

    public void set(int index, int value) {
        int[] baseList;
        int subListIndex = index / 1024;
        if (subListIndex >= this.baseLists.size()) {
            for (int i = this.baseLists.size(); i <= subListIndex; ++i) {
                this.baseLists.add(null);
            }
        }
        if ((baseList = this.baseLists.get(subListIndex)) == null) {
            baseList = new int[1024];
            this.baseLists.set(subListIndex, baseList);
        }
        baseList[index % 1024] = value;
        if (index > this.maxIndex) {
            this.maxIndex = index;
        }
    }

    public int get(int index) {
        if (index > this.maxIndex) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int subListIndex = index / 1024;
        int[] baseList = this.baseLists.get(subListIndex);
        if (baseList == null) {
            return 0;
        }
        return baseList[index % 1024];
    }

    public int baseListCount() {
        return this.baseLists.size();
    }

    public IntBuffer getBaseList(int index) {
        int[] array = this.baseLists.get(index);
        if (array == null) {
            return null;
        }
        IntBuffer retVal = IntBuffer.wrap(array);
        if (index + 1 == this.baseListCount()) {
            retVal.limit(this.maxIndex - index * 1024);
        }
        return retVal.asReadOnlyBuffer();
    }

    public int[] toArray() {
        int[] retVal = new int[this.length()];
        int currIndex = 0;
        for (int[] arr : this.baseLists) {
            int min = Math.min(this.length() - currIndex, arr.length);
            System.arraycopy(arr, 0, retVal, currIndex, min);
            currIndex += min;
        }
        return retVal;
    }
}

