/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.initialization;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.apache.hive.druid.io.druid.common.config.Log4jShutdown;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.apache.logging.log4j.spi.LoggerContextFactory;

public class Log4jShutterDownerModule
implements Module {
    private static final Logger log = new Logger(Log4jShutterDownerModule.class);

    public void configure(Binder binder) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            Class<?> logManagerClazz = Class.forName("org.apache.logging.log4j.LogManager", false, loader);
            Class<?> callbackRegistryClazz = Class.forName("org.apache.logging.log4j.core.util.ShutdownCallbackRegistry", false, loader);
            LoggerContextFactory contextFactory = LogManager.getFactory();
            if (!(contextFactory instanceof Log4jContextFactory)) {
                log.warn("Expected [%s] found [%s]. Unknown class for context factory. Not logging shutdown", Log4jContextFactory.class.getCanonicalName(), contextFactory.getClass().getCanonicalName());
                return;
            }
            ShutdownCallbackRegistry registry = ((Log4jContextFactory)contextFactory).getShutdownCallbackRegistry();
            if (!(registry instanceof Log4jShutdown)) {
                log.warn("Shutdown callback registry expected class [%s] found [%s]. Skipping shutdown registry", Log4jShutdown.class.getCanonicalName(), registry.getClass().getCanonicalName());
                return;
            }
            binder.bind(Log4jShutdown.class).toInstance((Object)((Log4jShutdown)registry));
            binder.bind(Key.get(Log4jShutterDowner.class, (Annotation)Names.named((String)"ForTheEagerness"))).to(Log4jShutterDowner.class).asEagerSingleton();
        }
        catch (ClassCastException | ClassNotFoundException | LinkageError e) {
            log.warn(e, "Not registering log4j shutdown hooks. Not using log4j?", new Object[0]);
        }
    }

    @ManageLifecycle
    @Provides
    public Log4jShutterDowner getShutterDowner(Log4jShutdown log4jShutdown) {
        return new Log4jShutterDowner(log4jShutdown);
    }

    public static class Log4jShutterDowner {
        private final Log4jShutdown log4jShutdown;

        public Log4jShutterDowner(Log4jShutdown log4jShutdown) {
            this.log4jShutdown = log4jShutdown;
        }

        @LifecycleStart
        public void start() {
            log.debug("Log4j shutter downer is waiting", new Object[0]);
        }

        @LifecycleStop
        public void stop() {
            if (this.log4jShutdown != null) {
                log.debug("Shutting down log4j", new Object[0]);
                this.log4jShutdown.stop();
            } else {
                log.warn("Log4j shutdown was registered in lifecycle but no shutdown object exists!", new Object[0]);
            }
        }
    }
}

