/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common.granularity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.io.druid.java.util.common.Cacheable;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.granularity.GranularityType;
import org.apache.hive.druid.io.druid.java.util.common.granularity.PeriodGranularity;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

public abstract class Granularity
implements Cacheable {
    private static final Pattern defaultPathPattern = Pattern.compile("^.*[Yy]=(\\d{4})/(?:[Mm]=(\\d{2})/(?:[Dd]=(\\d{2})/(?:[Hh]=(\\d{2})/(?:[Mm]=(\\d{2})/(?:[Ss]=(\\d{2})/)?)?)?)?)?.*$");
    private static final Pattern hivePathPattern = Pattern.compile("^.*dt=(\\d{4})(?:-(\\d{2})(?:-(\\d{2})(?:-(\\d{2})(?:-(\\d{2})(?:-(\\d{2})?)?)?)?)?)?/.*$");

    @JsonCreator
    public static Granularity fromString(String str) {
        return GranularityType.valueOf(StringUtils.toUpperCase(str)).getDefaultGranularity();
    }

    public static Granularity mergeGranularities(List<Granularity> toMerge) {
        if (toMerge == null || toMerge.size() == 0) {
            return null;
        }
        Granularity result = toMerge.get(0);
        for (int i = 1; i < toMerge.size(); ++i) {
            if (Objects.equals(result, toMerge.get(i))) continue;
            return null;
        }
        return result;
    }

    public static List<Granularity> granularitiesFinerThan(Granularity gran0) {
        ArrayList<Granularity> retVal = Lists.newArrayList();
        DateTime origin = gran0 instanceof PeriodGranularity ? ((PeriodGranularity)gran0).getOrigin() : null;
        DateTimeZone tz = gran0 instanceof PeriodGranularity ? ((PeriodGranularity)gran0).getTimeZone() : null;
        for (GranularityType gran : GranularityType.values()) {
            long gran0DurationMillis;
            Granularity segmentGranularity;
            long segmentGranularityDurationMillis;
            if (gran == GranularityType.ALL || gran == GranularityType.NONE || (segmentGranularityDurationMillis = (segmentGranularity = gran.create(origin, tz)).bucket(DateTimes.EPOCH).toDurationMillis()) > (gran0DurationMillis = gran0.bucket(DateTimes.EPOCH).toDurationMillis())) continue;
            retVal.add(segmentGranularity);
        }
        retVal.sort((g1, g2) -> {
            long duration1 = g2.bucket(DateTimes.EPOCH).toDurationMillis();
            long duration2 = g1.bucket(DateTimes.EPOCH).toDurationMillis();
            return Longs.compare(duration1, duration2);
        });
        return retVal;
    }

    public abstract DateTimeFormatter getFormatter(Formatter var1);

    public abstract DateTime increment(DateTime var1);

    public abstract DateTime decrement(DateTime var1);

    public abstract DateTime bucketStart(DateTime var1);

    public abstract DateTime toDate(String var1, Formatter var2);

    public DateTime bucketEnd(DateTime time) {
        return this.increment(this.bucketStart(time));
    }

    public DateTime toDateTime(long offset) {
        return DateTimes.utc(offset);
    }

    public DateTime toDate(String filePath) {
        return this.toDate(filePath, Formatter.DEFAULT);
    }

    public final String toPath(DateTime time) {
        return this.getFormatter(Formatter.DEFAULT).print((ReadableInstant)time);
    }

    public final Interval bucket(DateTime t) {
        DateTime start = this.bucketStart(t);
        return new Interval((ReadableInstant)start, (ReadableInstant)this.increment(start));
    }

    final Integer[] getDateValues(String filePath, Formatter formatter) {
        Pattern pattern = defaultPathPattern;
        switch (formatter) {
            case DEFAULT: 
            case LOWER_DEFAULT: {
                break;
            }
            case HIVE: {
                pattern = hivePathPattern;
                break;
            }
            default: {
                throw new IAE("Format %s not supported", new Object[]{formatter});
            }
        }
        Matcher matcher = pattern.matcher(filePath);
        Integer[] vals = new Integer[7];
        if (matcher.matches()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                vals[i] = matcher.group(i) != null ? Integer.valueOf(Integer.parseInt(matcher.group(i))) : null;
            }
        }
        return vals;
    }

    public Iterable<Interval> getIterable(Interval input) {
        return new IntervalIterable(input);
    }

    private class IntervalIterator
    implements Iterator<Interval> {
        private final Interval inputInterval;
        private DateTime currStart;
        private DateTime currEnd;

        private IntervalIterator(Interval inputInterval) {
            this.inputInterval = inputInterval;
            this.currStart = Granularity.this.bucketStart(inputInterval.getStart());
            this.currEnd = Granularity.this.increment(this.currStart);
        }

        @Override
        public boolean hasNext() {
            return this.currStart.isBefore((ReadableInstant)this.inputInterval.getEnd());
        }

        @Override
        public Interval next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("There are no more intervals");
            }
            Interval retVal = new Interval((ReadableInstant)this.currStart, (ReadableInstant)this.currEnd);
            this.currStart = this.currEnd;
            this.currEnd = Granularity.this.increment(this.currStart);
            return retVal;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class IntervalIterable
    implements Iterable<Interval> {
        private final Interval inputInterval;

        private IntervalIterable(Interval inputInterval) {
            this.inputInterval = inputInterval;
        }

        @Override
        public Iterator<Interval> iterator() {
            return new IntervalIterator(this.inputInterval);
        }
    }

    public static enum Formatter {
        DEFAULT,
        HIVE,
        LOWER_DEFAULT;

    }
}

