/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.last;

import org.apache.hive.druid.io.druid.collections.SerializablePair;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.segment.BaseFloatColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.BaseLongColumnValueSelector;

public class FloatLastAggregator
implements Aggregator {
    private final BaseFloatColumnValueSelector valueSelector;
    private final BaseLongColumnValueSelector timeSelector;
    protected long lastTime;
    protected float lastValue;

    public FloatLastAggregator(BaseLongColumnValueSelector timeSelector, BaseFloatColumnValueSelector valueSelector) {
        this.valueSelector = valueSelector;
        this.timeSelector = timeSelector;
        this.lastTime = Long.MIN_VALUE;
        this.lastValue = 0.0f;
    }

    @Override
    public void aggregate() {
        long time = this.timeSelector.getLong();
        if (time >= this.lastTime) {
            this.lastTime = time;
            this.lastValue = this.valueSelector.getFloat();
        }
    }

    @Override
    public Object get() {
        return new SerializablePair<Long, Float>(this.lastTime, Float.valueOf(this.lastValue));
    }

    @Override
    public float getFloat() {
        return this.lastValue;
    }

    @Override
    public long getLong() {
        return (long)this.lastValue;
    }

    @Override
    public double getDouble() {
        return this.lastValue;
    }

    @Override
    public void close() {
    }
}

