/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.last;

import java.nio.ByteBuffer;
import org.apache.hive.druid.io.druid.collections.SerializablePair;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.BaseLongColumnValueSelector;

public class LongLastBufferAggregator
implements BufferAggregator {
    private final BaseLongColumnValueSelector timeSelector;
    private final BaseLongColumnValueSelector valueSelector;

    public LongLastBufferAggregator(BaseLongColumnValueSelector timeSelector, BaseLongColumnValueSelector valueSelector) {
        this.timeSelector = timeSelector;
        this.valueSelector = valueSelector;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putLong(position, Long.MIN_VALUE);
        buf.putLong(position + 8, 0L);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        long lastTime;
        long time = this.timeSelector.getLong();
        if (time >= (lastTime = buf.getLong(position))) {
            buf.putLong(position, time);
            buf.putLong(position + 8, this.valueSelector.getLong());
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return new SerializablePair<Long, Long>(buf.getLong(position), buf.getLong(position + 8));
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return buf.getLong(position + 8);
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        return buf.getLong(position + 8);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return buf.getLong(position + 8);
    }

    @Override
    public void close() {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("timeSelector", this.timeSelector);
        inspector.visit("valueSelector", this.valueSelector);
    }
}

