/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.extraction;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.js.JavaScriptConfig;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptExtractionFn
implements ExtractionFn {
    private final String function;
    private final boolean injective;
    private final JavaScriptConfig config;
    private Function<Object, String> fn;

    private static Function<Object, String> compile(String function) {
        final ContextFactory contextFactory = ContextFactory.getGlobal();
        Context context = contextFactory.enterContext();
        context.setOptimizationLevel(9);
        final ScriptableObject scope = context.initStandardObjects();
        final org.mozilla.javascript.Function fn = context.compileFunction((Scriptable)scope, function, "fn", 1, null);
        Context.exit();
        return new Function<Object, String>(){

            @Override
            public String apply(Object input) {
                Object res;
                Context cx = Context.getCurrentContext();
                if (cx == null) {
                    cx = contextFactory.enterContext();
                }
                return (res = fn.call(cx, (Scriptable)scope, (Scriptable)scope, new Object[]{input})) != null ? Context.toString((Object)res) : null;
            }
        };
    }

    @JsonCreator
    public JavaScriptExtractionFn(@JsonProperty(value="function") String function, @JsonProperty(value="injective") boolean injective, @JacksonInject JavaScriptConfig config) {
        Preconditions.checkNotNull(function, "function must not be null");
        this.function = function;
        this.injective = injective;
        this.config = config;
    }

    @JsonProperty
    public String getFunction() {
        return this.function;
    }

    @JsonProperty
    public boolean isInjective() {
        return this.injective;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] bytes = StringUtils.toUtf8(this.function);
        return ByteBuffer.allocate(1 + bytes.length).put((byte)4).put(bytes).array();
    }

    @Override
    @Nullable
    public String apply(@Nullable Object value) {
        this.checkAndCompileScript();
        return Strings.emptyToNull(this.fn.apply(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndCompileScript() {
        if (this.fn == null) {
            Preconditions.checkState(this.config.isEnabled(), "JavaScript is disabled");
            JavaScriptConfig javaScriptConfig = this.config;
            synchronized (javaScriptConfig) {
                if (this.fn == null) {
                    this.fn = JavaScriptExtractionFn.compile(this.function);
                }
            }
        }
    }

    @Override
    @Nullable
    public String apply(@Nullable String value) {
        return this.apply((Object)Strings.emptyToNull(value));
    }

    @Override
    public String apply(long value) {
        return this.apply((Object)value);
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return this.injective ? ExtractionFn.ExtractionType.ONE_TO_ONE : ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public String toString() {
        return "JavascriptDimExtractionFn{function='" + this.function + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaScriptExtractionFn that = (JavaScriptExtractionFn)o;
        return this.function.equals(that.function);
    }

    public int hashCode() {
        return this.function.hashCode();
    }
}

