/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.filter;

import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.io.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.io.druid.query.filter.ValueGetter;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcherColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.filter.BooleanValueMatcher;

public class StringValueMatcherColumnSelectorStrategy
implements ValueMatcherColumnSelectorStrategy<DimensionSelector> {
    private static final String[] NULL_VALUE = new String[]{null};
    private static final ValueGetter NULL_VALUE_GETTER = new ValueGetter(){

        @Override
        public String[] get() {
            return NULL_VALUE;
        }
    };

    @Override
    public ValueMatcher makeValueMatcher(DimensionSelector selector, String value) {
        value = Strings.emptyToNull(value);
        if (selector.getValueCardinality() == 0) {
            return BooleanValueMatcher.of(value == null);
        }
        return selector.makeValueMatcher(value);
    }

    @Override
    public ValueMatcher makeValueMatcher(DimensionSelector selector, DruidPredicateFactory predicateFactory) {
        Predicate<String> predicate = predicateFactory.makeStringPredicate();
        if (selector.getValueCardinality() == 0) {
            return BooleanValueMatcher.of(predicate.apply(null));
        }
        return selector.makeValueMatcher(predicate);
    }

    @Override
    public ValueGetter makeValueGetter(final DimensionSelector selector) {
        if (selector.getValueCardinality() == 0) {
            return NULL_VALUE_GETTER;
        }
        return new ValueGetter(){

            @Override
            public String[] get() {
                IndexedInts row = selector.getRow();
                int size = row.size();
                if (size == 0) {
                    return NULL_VALUE;
                }
                String[] values = new String[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = Strings.emptyToNull(selector.lookupName(row.get(i)));
                }
                return values;
            }
        };
    }
}

