/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.topn;

import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicates;
import org.apache.hive.druid.io.druid.collections.NonBlockingPool;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.topn.AggregateTopNMetricFirstAlgorithm;
import org.apache.hive.druid.io.druid.query.topn.DimExtractionTopNAlgorithm;
import org.apache.hive.druid.io.druid.query.topn.PooledTopNAlgorithm;
import org.apache.hive.druid.io.druid.query.topn.TimeExtractionTopNAlgorithm;
import org.apache.hive.druid.io.druid.query.topn.TopNAlgorithm;
import org.apache.hive.druid.io.druid.query.topn.TopNAlgorithmSelector;
import org.apache.hive.druid.io.druid.query.topn.TopNMapFn;
import org.apache.hive.druid.io.druid.query.topn.TopNParams;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryMetrics;
import org.apache.hive.druid.io.druid.query.topn.TopNResultValue;
import org.apache.hive.druid.io.druid.segment.Capabilities;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.SegmentMissingException;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.filter.Filters;
import org.joda.time.Interval;

public class TopNQueryEngine {
    private final NonBlockingPool<ByteBuffer> bufferPool;

    public TopNQueryEngine(NonBlockingPool<ByteBuffer> bufferPool) {
        this.bufferPool = bufferPool;
    }

    public Sequence<Result<TopNResultValue>> query(TopNQuery query, StorageAdapter adapter, final @Nullable TopNQueryMetrics queryMetrics) {
        if (adapter == null) {
            throw new SegmentMissingException("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        List<Interval> queryIntervals = query.getQuerySegmentSpec().getIntervals();
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getDimensionsFilter()));
        Granularity granularity = query.getGranularity();
        final TopNMapFn mapFn = this.getMapFn(query, adapter, queryMetrics);
        Preconditions.checkArgument(queryIntervals.size() == 1, "Can only handle a single interval, got[%s]", queryIntervals);
        return Sequences.filter(Sequences.map(adapter.makeCursors(filter, queryIntervals.get(0), query.getVirtualColumns(), granularity, query.isDescending(), queryMetrics), new Function<Cursor, Result<TopNResultValue>>(){

            @Override
            public Result<TopNResultValue> apply(Cursor input) {
                if (queryMetrics != null) {
                    queryMetrics.cursor(input);
                }
                return mapFn.apply(input, queryMetrics);
            }
        }), Predicates.notNull());
    }

    private TopNMapFn getMapFn(TopNQuery query, StorageAdapter adapter, @Nullable TopNQueryMetrics queryMetrics) {
        Capabilities capabilities = adapter.getCapabilities();
        String dimension = query.getDimensionSpec().getDimension();
        int cardinality = adapter.getDimensionCardinality(dimension);
        if (queryMetrics != null) {
            queryMetrics.dimensionCardinality(cardinality);
        }
        int numBytesPerRecord = 0;
        for (AggregatorFactory aggregatorFactory : query.getAggregatorSpecs()) {
            numBytesPerRecord += aggregatorFactory.getMaxIntermediateSize();
        }
        TopNAlgorithmSelector selector = new TopNAlgorithmSelector(cardinality, numBytesPerRecord);
        query.initTopNAlgorithmSelector(selector);
        ColumnCapabilities columnCapabilities = query.getVirtualColumns().getColumnCapabilitiesWithFallback(adapter, dimension);
        TopNAlgorithm<Aggregator[][], TopNParams> topNAlgorithm = selector.isHasExtractionFn() && dimension.equals("__time") ? new TimeExtractionTopNAlgorithm(capabilities, query) : (selector.isHasExtractionFn() ? new DimExtractionTopNAlgorithm(capabilities, query) : (columnCapabilities != null && (columnCapabilities.getType() != ValueType.STRING || !columnCapabilities.isDictionaryEncoded()) ? new DimExtractionTopNAlgorithm(capabilities, query) : (selector.isAggregateAllMetrics() ? new PooledTopNAlgorithm(capabilities, query, this.bufferPool) : (selector.isAggregateTopNMetricFirst() || query.getContextBoolean("doAggregateTopNMetricFirst", false) ? new AggregateTopNMetricFirstAlgorithm(capabilities, query, this.bufferPool) : new PooledTopNAlgorithm(capabilities, query, this.bufferPool)))));
        if (queryMetrics != null) {
            queryMetrics.algorithm(topNAlgorithm);
        }
        return new TopNMapFn(query, topNAlgorithm);
    }

    public static boolean canApplyExtractionInPost(TopNQuery query) {
        return query.getDimensionSpec() != null && query.getDimensionSpec().getExtractionFn() != null && ExtractionFn.ExtractionType.ONE_TO_ONE.equals((Object)query.getDimensionSpec().getExtractionFn().getExtractionType()) && query.getTopNMetricSpec().canBeOptimizedUnordered();
    }
}

