/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.topn.types;

import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.topn.BaseTopNAlgorithm;
import org.apache.hive.druid.io.druid.query.topn.TopNParams;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNResultBuilder;
import org.apache.hive.druid.io.druid.query.topn.types.TopNColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.segment.Capabilities;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;

public class StringTopNColumnSelectorStrategy
implements TopNColumnSelectorStrategy<DimensionSelector, Map<String, Aggregator[]>> {
    @Override
    public int getCardinality(DimensionSelector selector) {
        return selector.getValueCardinality();
    }

    @Override
    public ValueType getValueType() {
        return ValueType.STRING;
    }

    @Override
    public Aggregator[][] getDimExtractionRowSelector(TopNQuery query, TopNParams params, Capabilities capabilities) {
        if (params.getCardinality() < 0) {
            throw new UnsupportedOperationException("Cannot operate on a dimension with unknown cardinality");
        }
        BaseTopNAlgorithm.AggregatorArrayProvider provider = new BaseTopNAlgorithm.AggregatorArrayProvider((DimensionSelector)params.getSelectorPlus().getSelector(), query, params.getCardinality(), capabilities);
        return provider.build();
    }

    @Override
    public Map<String, Aggregator[]> makeDimExtractionAggregateStore() {
        return Maps.newHashMap();
    }

    @Override
    public long dimExtractionScanAndAggregate(TopNQuery query, DimensionSelector selector, Cursor cursor, Aggregator[][] rowSelector, Map<String, Aggregator[]> aggregatesStore) {
        if (selector.getValueCardinality() != -1) {
            return this.dimExtractionScanAndAggregateWithCardinalityKnown(query, cursor, selector, rowSelector, aggregatesStore);
        }
        return this.dimExtractionScanAndAggregateWithCardinalityUnknown(query, cursor, selector, aggregatesStore);
    }

    @Override
    public void updateDimExtractionResults(Map<String, Aggregator[]> aggregatesStore, Function<Object, Object> valueTransformer, TopNResultBuilder resultBuilder) {
        for (Map.Entry<String, Aggregator[]> entry : aggregatesStore.entrySet()) {
            Aggregator[] aggs = entry.getValue();
            if (aggs == null) continue;
            Object[] vals = new Object[aggs.length];
            for (int i = 0; i < aggs.length; ++i) {
                vals[i] = aggs[i].get();
            }
            Comparable key = (Comparable)((Object)entry.getKey());
            if (valueTransformer != null) {
                key = (Comparable)valueTransformer.apply(key);
            }
            resultBuilder.addEntry(key, key, vals);
        }
    }

    private long dimExtractionScanAndAggregateWithCardinalityKnown(TopNQuery query, Cursor cursor, DimensionSelector selector, Aggregator[][] rowSelector, Map<String, Aggregator[]> aggregatesStore) {
        long processedRows = 0L;
        while (!cursor.isDone()) {
            IndexedInts dimValues = selector.getRow();
            for (int i = 0; i < dimValues.size(); ++i) {
                int dimIndex = dimValues.get(i);
                Aggregator[] theAggregators = rowSelector[dimIndex];
                if (theAggregators == null) {
                    String key = selector.lookupName(dimIndex);
                    theAggregators = aggregatesStore.get(key);
                    if (theAggregators == null) {
                        theAggregators = BaseTopNAlgorithm.makeAggregators(cursor, query.getAggregatorSpecs());
                        aggregatesStore.put(key, theAggregators);
                    }
                    rowSelector[dimIndex] = theAggregators;
                }
                for (Aggregator aggregator : theAggregators) {
                    aggregator.aggregate();
                }
            }
            cursor.advance();
            ++processedRows;
        }
        return processedRows;
    }

    private long dimExtractionScanAndAggregateWithCardinalityUnknown(TopNQuery query, Cursor cursor, DimensionSelector selector, Map<String, Aggregator[]> aggregatesStore) {
        long processedRows = 0L;
        while (!cursor.isDone()) {
            IndexedInts dimValues = selector.getRow();
            for (int i = 0; i < dimValues.size(); ++i) {
                int dimIndex = dimValues.get(i);
                String key = selector.lookupName(dimIndex);
                Aggregator[] theAggregators = aggregatesStore.get(key);
                if (theAggregators == null) {
                    theAggregators = BaseTopNAlgorithm.makeAggregators(cursor, query.getAggregatorSpecs());
                    aggregatesStore.put(key, theAggregators);
                }
                for (Aggregator aggregator : theAggregators) {
                    aggregator.aggregate();
                }
            }
            cursor.advance();
            ++processedRows;
        }
        return processedRows;
    }
}

