/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.column;

import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.hive.druid.io.druid.segment.column.BitmapIndex;
import org.apache.hive.druid.io.druid.segment.column.Column;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.hive.druid.io.druid.segment.column.ComplexColumn;
import org.apache.hive.druid.io.druid.segment.column.DictionaryEncodedColumn;
import org.apache.hive.druid.io.druid.segment.column.GenericColumn;
import org.apache.hive.druid.io.druid.segment.column.SimpleColumn;
import org.apache.hive.druid.io.druid.segment.column.SpatialIndex;
import org.apache.hive.druid.io.druid.segment.column.ValueType;

public class ColumnBuilder {
    private ValueType type = null;
    private boolean hasMultipleValues = false;
    private Supplier<DictionaryEncodedColumn> dictionaryEncodedColumn = null;
    private Supplier<GenericColumn> genericColumn = null;
    private Supplier<ComplexColumn> complexColumn = null;
    private Supplier<BitmapIndex> bitmapIndex = null;
    private Supplier<SpatialIndex> spatialIndex = null;
    private SmooshedFileMapper fileMapper = null;

    public ColumnBuilder setFileMapper(SmooshedFileMapper fileMapper) {
        this.fileMapper = fileMapper;
        return this;
    }

    public SmooshedFileMapper getFileMapper() {
        return this.fileMapper;
    }

    public ColumnBuilder setType(ValueType type) {
        this.type = type;
        return this;
    }

    public ColumnBuilder setHasMultipleValues(boolean hasMultipleValues) {
        this.hasMultipleValues = hasMultipleValues;
        return this;
    }

    public ColumnBuilder setDictionaryEncodedColumn(Supplier<DictionaryEncodedColumn> dictionaryEncodedColumn) {
        this.dictionaryEncodedColumn = dictionaryEncodedColumn;
        return this;
    }

    public ColumnBuilder setGenericColumn(Supplier<GenericColumn> genericColumn) {
        this.genericColumn = genericColumn;
        return this;
    }

    public ColumnBuilder setComplexColumn(Supplier<ComplexColumn> complexColumn) {
        this.complexColumn = complexColumn;
        return this;
    }

    public ColumnBuilder setBitmapIndex(Supplier<BitmapIndex> bitmapIndex) {
        this.bitmapIndex = bitmapIndex;
        return this;
    }

    public ColumnBuilder setSpatialIndex(Supplier<SpatialIndex> spatialIndex) {
        this.spatialIndex = spatialIndex;
        return this;
    }

    public Column build() {
        Preconditions.checkState(this.type != null, "Type must be set.");
        return new SimpleColumn(new ColumnCapabilitiesImpl().setType(this.type).setDictionaryEncoded(this.dictionaryEncodedColumn != null).setHasBitmapIndexes(this.bitmapIndex != null).setHasSpatialIndexes(this.spatialIndex != null).setHasMultipleValues(this.hasMultipleValues), this.dictionaryEncodedColumn, this.genericColumn, this.complexColumn, this.bitmapIndex, this.spatialIndex);
    }
}

