/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.appenderator;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.data.input.Committer;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.Appenderator;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.AppenderatorDriverAddResult;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.AppenderatorDriverMetadata;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentAllocator;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentIdentifier;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentNotWritableException;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentWithState;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentsAndMetadata;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.TransactionalSegmentPublisher;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.UsedSegmentChecker;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public abstract class BaseAppenderatorDriver
implements Closeable {
    private static final Logger log = new Logger(BaseAppenderatorDriver.class);
    private final SegmentAllocator segmentAllocator;
    private final UsedSegmentChecker usedSegmentChecker;
    protected final Appenderator appenderator;
    protected final Map<String, SegmentsForSequence> segments = new TreeMap<String, SegmentsForSequence>();
    protected final ListeningExecutorService executor;

    BaseAppenderatorDriver(Appenderator appenderator, SegmentAllocator segmentAllocator, UsedSegmentChecker usedSegmentChecker) {
        this.appenderator = Preconditions.checkNotNull(appenderator, "appenderator");
        this.segmentAllocator = Preconditions.checkNotNull(segmentAllocator, "segmentAllocator");
        this.usedSegmentChecker = Preconditions.checkNotNull(usedSegmentChecker, "usedSegmentChecker");
        this.executor = MoreExecutors.listeningDecorator(Execs.singleThreaded("publish-%d"));
    }

    @VisibleForTesting
    Map<String, SegmentsForSequence> getSegments() {
        return this.segments;
    }

    @Nullable
    public abstract Object startJob();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentIdentifier getAppendableSegment(DateTime timestamp, String sequenceName) {
        Map<String, SegmentsForSequence> map = this.segments;
        synchronized (map) {
            SegmentsForSequence segmentsForSequence = this.segments.get(sequenceName);
            if (segmentsForSequence == null) {
                return null;
            }
            Map.Entry<Long, LinkedList<SegmentWithState>> candidateEntry = segmentsForSequence.floor(timestamp.getMillis());
            if (candidateEntry != null && candidateEntry.getValue().getFirst().getSegmentIdentifier().getInterval().contains((ReadableInstant)timestamp) && candidateEntry.getValue().getFirst().getState() == SegmentWithState.SegmentState.APPENDING) {
                return candidateEntry.getValue().getFirst().getSegmentIdentifier();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentIdentifier getSegment(InputRow row, String sequenceName, boolean skipSegmentLineageCheck) throws IOException {
        Map<String, SegmentsForSequence> map = this.segments;
        synchronized (map) {
            DateTime timestamp = row.getTimestamp();
            SegmentIdentifier existing = this.getAppendableSegment(timestamp, sequenceName);
            if (existing != null) {
                return existing;
            }
            SegmentsForSequence segmentsForSequence = this.segments.get(sequenceName);
            SegmentIdentifier newSegment = this.segmentAllocator.allocate(row, sequenceName, segmentsForSequence == null ? null : segmentsForSequence.lastSegmentId, skipSegmentLineageCheck);
            if (newSegment != null) {
                for (SegmentIdentifier identifier : this.appenderator.getSegments()) {
                    if (!identifier.equals(newSegment)) continue;
                    throw new ISE("WTF?! Allocated segment[%s] which conflicts with existing segment[%s].", newSegment, identifier);
                }
                log.info("New segment[%s] for row[%s] sequenceName[%s].", newSegment, row, sequenceName);
                this.addSegment(sequenceName, newSegment);
            } else {
                log.warn("Cannot allocate segment for timestamp[%s], sequenceName[%s]. ", timestamp, sequenceName);
            }
            return newSegment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSegment(String sequenceName, SegmentIdentifier identifier) {
        Map<String, SegmentsForSequence> map = this.segments;
        synchronized (map) {
            this.segments.computeIfAbsent(sequenceName, k -> new SegmentsForSequence()).add(identifier);
        }
    }

    protected AppenderatorDriverAddResult append(InputRow row, String sequenceName, @Nullable Supplier<Committer> committerSupplier, boolean skipSegmentLineageCheck, boolean allowIncrementalPersists) throws IOException {
        Preconditions.checkNotNull(row, "row");
        Preconditions.checkNotNull(sequenceName, "sequenceName");
        SegmentIdentifier identifier = this.getSegment(row, sequenceName, skipSegmentLineageCheck);
        if (identifier != null) {
            try {
                Appenderator.AppenderatorAddResult result = this.appenderator.add(identifier, row, committerSupplier == null ? null : this.wrapCommitterSupplier(committerSupplier), allowIncrementalPersists);
                return AppenderatorDriverAddResult.ok(identifier, result.getNumRowsInSegment(), this.appenderator.getTotalRowCount(), result.isPersistRequired());
            }
            catch (SegmentNotWritableException e) {
                throw new ISE(e, "WTF?! Segment[%s] not writable when it should have been.", identifier);
            }
        }
        return AppenderatorDriverAddResult.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Stream<SegmentWithState> getSegmentWithStates(Collection<String> sequenceNames) {
        Map<String, SegmentsForSequence> map = this.segments;
        synchronized (map) {
            return sequenceNames.stream().map(this.segments::get).filter(Objects::nonNull).flatMap(segmentsForSequence -> ((SegmentsForSequence)segmentsForSequence).intervalToSegmentStates.values().stream()).flatMap(Collection::stream);
        }
    }

    ListenableFuture<SegmentsAndMetadata> pushInBackground(@Nullable WrappedCommitter wrappedCommitter, Collection<SegmentIdentifier> segmentIdentifiers) {
        log.info("Pushing segments in background: [%s]", Joiner.on(", ").join(segmentIdentifiers));
        return Futures.transform(this.appenderator.push(segmentIdentifiers, wrappedCommitter), segmentsAndMetadata -> {
            Set pushedSegments = segmentsAndMetadata.getSegments().stream().map(SegmentIdentifier::fromDataSegment).collect(Collectors.toSet());
            if (!pushedSegments.equals(Sets.newHashSet(segmentIdentifiers))) {
                throw new ISE("WTF?! Pushed different segments than requested. Pushed[%s], requested[%s].", pushedSegments, segmentIdentifiers);
            }
            return segmentsAndMetadata;
        }, (Executor)this.executor);
    }

    ListenableFuture<SegmentsAndMetadata> dropInBackground(SegmentsAndMetadata segmentsAndMetadata) {
        log.info("Dropping segments[%s]", segmentsAndMetadata.getSegments());
        ListenableFuture dropFuture = Futures.allAsList(segmentsAndMetadata.getSegments().stream().map(segment -> this.appenderator.drop(SegmentIdentifier.fromDataSegment(segment))).collect(Collectors.toList()));
        return Futures.transform(dropFuture, x -> {
            Object metadata = segmentsAndMetadata.getCommitMetadata();
            return new SegmentsAndMetadata(segmentsAndMetadata.getSegments(), metadata == null ? null : ((AppenderatorDriverMetadata)metadata).getCallerMetadata());
        });
    }

    ListenableFuture<SegmentsAndMetadata> publishInBackground(SegmentsAndMetadata segmentsAndMetadata, TransactionalSegmentPublisher publisher) {
        return this.executor.submit(() -> {
            block6: {
                if (segmentsAndMetadata.getSegments().isEmpty()) {
                    log.info("Nothing to publish, skipping publish step.", new Object[0]);
                } else {
                    log.info("Publishing segments with commitMetadata[%s]: [%s]", segmentsAndMetadata.getCommitMetadata(), Joiner.on(", ").join(segmentsAndMetadata.getSegments()));
                    try {
                        Object metadata = segmentsAndMetadata.getCommitMetadata();
                        boolean published = publisher.publishSegments(ImmutableSet.copyOf(segmentsAndMetadata.getSegments()), metadata == null ? null : ((AppenderatorDriverMetadata)metadata).getCallerMetadata());
                        if (published) {
                            log.info("Published segments.", new Object[0]);
                            break block6;
                        }
                        log.info("Transaction failure while publishing segments, checking if someone else beat us to it.", new Object[0]);
                        Set<SegmentIdentifier> segmentsIdentifiers = segmentsAndMetadata.getSegments().stream().map(SegmentIdentifier::fromDataSegment).collect(Collectors.toSet());
                        if (this.usedSegmentChecker.findUsedSegments(segmentsIdentifiers).equals(Sets.newHashSet(segmentsAndMetadata.getSegments()))) {
                            log.info("Our segments really do exist, awaiting handoff.", new Object[0]);
                            break block6;
                        }
                        throw new ISE("Failed to publish segments[%s]", segmentsAndMetadata.getSegments());
                    }
                    catch (IOException e) {
                        throw Throwables.propagate(e);
                    }
                }
            }
            return segmentsAndMetadata;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws InterruptedException {
        Map<String, SegmentsForSequence> map = this.segments;
        synchronized (map) {
            this.segments.clear();
        }
        this.appenderator.clear();
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WrappedCommitter wrapCommitter(Committer committer) {
        ImmutableMap<String, SegmentsForSequence> snapshot;
        Map<String, SegmentsForSequence> map = this.segments;
        synchronized (map) {
            snapshot = ImmutableMap.copyOf(this.segments);
        }
        AppenderatorDriverMetadata wrappedMetadata = new AppenderatorDriverMetadata(ImmutableMap.copyOf(Maps.transformValues(snapshot, input -> ImmutableList.copyOf(((SegmentsForSequence)input).intervalToSegmentStates.values().stream().flatMap(Collection::stream).collect(Collectors.toList())))), snapshot.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SegmentsForSequence)e.getValue()).lastSegmentId)), committer.getMetadata());
        return new WrappedCommitter(committer, wrappedMetadata);
    }

    private Supplier<Committer> wrapCommitterSupplier(Supplier<Committer> committerSupplier) {
        return () -> this.wrapCommitter((Committer)committerSupplier.get());
    }

    static class WrappedCommitter
    implements Committer {
        private final Committer delegate;
        private final AppenderatorDriverMetadata metadata;

        WrappedCommitter(Committer delegate, AppenderatorDriverMetadata metadata) {
            this.delegate = delegate;
            this.metadata = metadata;
        }

        @Override
        public Object getMetadata() {
            return this.metadata;
        }

        @Override
        public void run() {
            this.delegate.run();
        }
    }

    static class SegmentsForSequence {
        private final NavigableMap<Long, LinkedList<SegmentWithState>> intervalToSegmentStates;
        private String lastSegmentId;

        SegmentsForSequence() {
            this.intervalToSegmentStates = new TreeMap<Long, LinkedList<SegmentWithState>>();
        }

        SegmentsForSequence(NavigableMap<Long, LinkedList<SegmentWithState>> intervalToSegmentStates, String lastSegmentId) {
            this.intervalToSegmentStates = intervalToSegmentStates;
            this.lastSegmentId = lastSegmentId;
        }

        void add(SegmentIdentifier identifier) {
            this.intervalToSegmentStates.computeIfAbsent(identifier.getInterval().getStartMillis(), k -> new LinkedList()).addFirst(SegmentWithState.newSegment(identifier));
            this.lastSegmentId = identifier.getIdentifierAsString();
        }

        Map.Entry<Long, LinkedList<SegmentWithState>> floor(long timestamp) {
            return this.intervalToSegmentStates.floorEntry(timestamp);
        }

        LinkedList<SegmentWithState> get(long timestamp) {
            return (LinkedList)this.intervalToSegmentStates.get(timestamp);
        }

        Stream<SegmentWithState> segmentStateStream() {
            return this.intervalToSegmentStates.values().stream().flatMap(Collection::stream);
        }
    }
}

