/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.router;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.hive.druid.io.druid.client.selector.Server;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.server.router.AvaticaConnectionBalancer;
import org.apache.hive.druid.io.druid.server.router.TieredBrokerHostSelector;

public class QueryHostFinder {
    private static EmittingLogger log = new EmittingLogger(QueryHostFinder.class);
    private final TieredBrokerHostSelector hostSelector;
    private final AvaticaConnectionBalancer avaticaConnectionBalancer;
    private final ConcurrentHashMap<String, Server> serverBackup = new ConcurrentHashMap();

    @Inject
    public QueryHostFinder(TieredBrokerHostSelector hostSelector, AvaticaConnectionBalancer avaticaConnectionBalancer) {
        this.hostSelector = hostSelector;
        this.avaticaConnectionBalancer = avaticaConnectionBalancer;
    }

    public <T> Server findServer(Query<T> query) {
        Pair<String, Server> selected = this.hostSelector.select(query);
        return this.findServerInner(selected);
    }

    public Server findDefaultServer() {
        Pair<String, Server> selected = this.hostSelector.getDefaultLookup();
        return this.findServerInner(selected);
    }

    public Collection<Server> getAllServers() {
        return this.hostSelector.getAllBrokers().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Server findServerAvatica(String connectionId) {
        Server chosenServer = this.avaticaConnectionBalancer.pickServer(this.getAllServers(), connectionId);
        if (chosenServer == null) {
            log.makeAlert("Catastrophic failure! No servers found at all! Failing request!", new Object[0]).emit();
            throw new ISE("No server found for Avatica request with connectionId[%s]", connectionId);
        }
        log.debug("Balancer class [%s] sending request with connectionId[%s] to server: %s", this.avaticaConnectionBalancer.getClass(), connectionId, chosenServer.getHost());
        return chosenServer;
    }

    public <T> Server getServer(Query<T> query) {
        Server server = this.findServer(query);
        if (server == null) {
            log.makeAlert("Catastrophic failure! No servers found at all! Failing request!", new Object[0]).emit();
            throw new ISE("No server found for query[%s]", query);
        }
        log.debug("Selected [%s]", server.getHost());
        return server;
    }

    public Server getDefaultServer() {
        Server server = this.findDefaultServer();
        if (server == null) {
            log.makeAlert("Catastrophic failure! No servers found at all! Failing request!", new Object[0]).emit();
            throw new ISE("No default server found!", new Object[0]);
        }
        return server;
    }

    private Server findServerInner(Pair<String, Server> selected) {
        Server server;
        if (selected == null) {
            log.error("Danger, Will Robinson! Unable to find any brokers!", new Object[0]);
        }
        String serviceName = selected == null ? this.hostSelector.getDefaultServiceName() : (String)selected.lhs;
        Server server2 = server = selected == null ? null : (Server)selected.rhs;
        if (server == null) {
            log.error("WTF?! No server found for serviceName[%s]. Using backup", serviceName);
            server = this.serverBackup.get(serviceName);
            if (server == null) {
                log.error("WTF?! No backup found for serviceName[%s]. Using default[%s]", serviceName, this.hostSelector.getDefaultServiceName());
                server = this.serverBackup.get(this.hostSelector.getDefaultServiceName());
            }
        }
        if (server != null) {
            this.serverBackup.put(serviceName, server);
        }
        return server;
    }
}

