/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.storage.hdfs;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HadoopFsWrapper;
import org.apache.hadoop.fs.Path;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.io.ByteSink;
import org.apache.hive.druid.com.google.common.io.ByteSource;
import org.apache.hive.druid.io.druid.common.utils.UUIDUtils;
import org.apache.hive.druid.io.druid.java.util.common.CompressionUtils;
import org.apache.hive.druid.io.druid.java.util.common.IOE;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.segment.SegmentUtils;
import org.apache.hive.druid.io.druid.segment.loading.DataSegmentPusher;
import org.apache.hive.druid.io.druid.storage.hdfs.HdfsDataSegmentPusherConfig;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.joda.time.format.ISODateTimeFormat;

public class HdfsDataSegmentPusher
implements DataSegmentPusher {
    private static final Logger log = new Logger(HdfsDataSegmentPusher.class);
    private final HdfsDataSegmentPusherConfig config;
    private final Configuration hadoopConfig;
    private final ObjectMapper jsonMapper;
    private final String fullyQualifiedStorageDirectory;

    @Inject
    public HdfsDataSegmentPusher(HdfsDataSegmentPusherConfig config, Configuration hadoopConfig, ObjectMapper jsonMapper) throws IOException {
        this.config = config;
        this.hadoopConfig = hadoopConfig;
        this.jsonMapper = jsonMapper;
        Path storageDir = new Path(config.getStorageDirectory());
        this.fullyQualifiedStorageDirectory = FileSystem.newInstance((URI)storageDir.toUri(), (Configuration)hadoopConfig).makeQualified(storageDir).toUri().toString();
        log.info("Configured HDFS as deep storage", new Object[0]);
    }

    @Override
    @Deprecated
    public String getPathForHadoop(String dataSource) {
        return this.getPathForHadoop();
    }

    @Override
    public String getPathForHadoop() {
        return this.fullyQualifiedStorageDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSegment push(File inDir, DataSegment segment, boolean replaceExisting) throws IOException {
        DataSegment dataSegment;
        String storageDir = this.getStorageDir(segment);
        log.info("Copying segment[%s] to HDFS at location[%s/%s]", segment.getIdentifier(), this.fullyQualifiedStorageDirectory, storageDir);
        Path tmpIndexFile = new Path(StringUtils.format("%s/%s/%s/%s_index.zip", this.fullyQualifiedStorageDirectory, segment.getDataSource(), UUIDUtils.generateUuid(new String[0]), segment.getShardSpec().getPartitionNum()));
        FileSystem fs = tmpIndexFile.getFileSystem(this.hadoopConfig);
        fs.mkdirs(tmpIndexFile.getParent());
        log.info("Compressing files from[%s] to [%s]", inDir, tmpIndexFile);
        try (FSDataOutputStream out = fs.create(tmpIndexFile);){
            long size = CompressionUtils.zip(inDir, (OutputStream)out);
            Path outIndexFile = new Path(StringUtils.format("%s/%s/%d_index.zip", this.fullyQualifiedStorageDirectory, storageDir, segment.getShardSpec().getPartitionNum()));
            Path outDescriptorFile = new Path(StringUtils.format("%s/%s/%d_descriptor.json", this.fullyQualifiedStorageDirectory, storageDir, segment.getShardSpec().getPartitionNum()));
            dataSegment = segment.withLoadSpec(this.makeLoadSpec(outIndexFile.toUri())).withSize(size).withBinaryVersion(SegmentUtils.getVersionFromDir(inDir));
            Path tmpDescriptorFile = new Path(tmpIndexFile.getParent(), StringUtils.format("%s_descriptor.json", dataSegment.getShardSpec().getPartitionNum()));
            log.info("Creating descriptor file at[%s]", tmpDescriptorFile);
            ByteSource.wrap(this.jsonMapper.writeValueAsBytes(dataSegment)).copyTo(new HdfsOutputStreamSupplier(fs, tmpDescriptorFile));
            fs.mkdirs(outIndexFile.getParent());
            this.copyFilesWithChecks(fs, tmpDescriptorFile, outDescriptorFile, replaceExisting);
            this.copyFilesWithChecks(fs, tmpIndexFile, outIndexFile, replaceExisting);
        }
        catch (Throwable throwable) {
            try {
                if (fs.exists(tmpIndexFile.getParent()) && !fs.delete(tmpIndexFile.getParent(), true)) {
                    log.error("Failed to delete temp directory[%s]", tmpIndexFile.getParent());
                }
            }
            catch (IOException ex) {
                log.error(ex, "Failed to delete temp directory[%s]", tmpIndexFile.getParent());
            }
            throw throwable;
        }
        try {
            if (fs.exists(tmpIndexFile.getParent()) && !fs.delete(tmpIndexFile.getParent(), true)) {
                log.error("Failed to delete temp directory[%s]", tmpIndexFile.getParent());
            }
        }
        catch (IOException ex) {
            log.error(ex, "Failed to delete temp directory[%s]", tmpIndexFile.getParent());
        }
        return dataSegment;
    }

    private void copyFilesWithChecks(FileSystem fs, Path from, Path to, boolean replaceExisting) throws IOException {
        if (!HadoopFsWrapper.rename(fs, from, to, replaceExisting)) {
            if (fs.exists(to)) {
                log.info("Unable to rename temp Index file[%s] to final segment path [%s]. It is already pushed by a replica task.", from, to);
            } else {
                throw new IOE("Failed to rename temp Index file[%s] and final segment path[%s] is not present.", from, to);
            }
        }
    }

    @Override
    public Map<String, Object> makeLoadSpec(URI finalIndexZipFilePath) {
        return ImmutableMap.of("type", "hdfs", "path", finalIndexZipFilePath.toString());
    }

    @Override
    public String getStorageDir(DataSegment segment) {
        return JOINER.join(segment.getDataSource(), StringUtils.format("%s_%s", segment.getInterval().getStart().toString(ISODateTimeFormat.basicDateTime()), segment.getInterval().getEnd().toString(ISODateTimeFormat.basicDateTime())), segment.getVersion().replaceAll(":", "_"));
    }

    @Override
    public String makeIndexPathName(DataSegment dataSegment, String indexName) {
        return StringUtils.format("./%s/%d_%s", this.getStorageDir(dataSegment), dataSegment.getShardSpec().getPartitionNum(), indexName);
    }

    private static class HdfsOutputStreamSupplier
    extends ByteSink {
        private final FileSystem fs;
        private final Path descriptorFile;

        public HdfsOutputStreamSupplier(FileSystem fs, Path descriptorFile) {
            this.fs = fs;
            this.descriptorFile = descriptorFile;
        }

        @Override
        public OutputStream openStream() throws IOException {
            return this.fs.create(this.descriptorFile);
        }
    }
}

