/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.druid;

import java.io.IOException;
import java.util.Locale;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidJson;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidType;

public class VirtualColumn
implements DruidJson {
    private final String name;
    private final String expression;
    private final DruidType outputType;

    public VirtualColumn(String name, String expression, DruidType outputType) {
        this.name = Preconditions.checkNotNull(name);
        this.expression = Preconditions.checkNotNull(expression);
        this.outputType = outputType == null ? DruidType.FLOAT : outputType;
    }

    @Override
    public void write(JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("type", "expression");
        generator.writeStringField("name", this.name);
        generator.writeStringField("expression", this.expression);
        DruidQuery.writeFieldIf(generator, "outputType", this.getOutputType().toString().toUpperCase(Locale.ENGLISH));
        generator.writeEndObject();
    }

    public String getName() {
        return this.name;
    }

    public String getExpression() {
        return this.expression;
    }

    public DruidType getOutputType() {
        return this.outputType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String expression;
        private DruidType type;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withExpression(String expression) {
            this.expression = expression;
            return this;
        }

        public Builder withType(DruidType type) {
            this.type = type;
            return this;
        }

        public VirtualColumn build() {
            return new VirtualColumn(this.name, this.expression, this.type);
        }
    }
}

