/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel;

import org.apache.hive.druid.org.apache.calcite.plan.RelOptPlanner;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitDef;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollation;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollations;
import org.apache.hive.druid.org.apache.calcite.rel.RelFieldCollation;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalSort;

public class RelCollationTraitDef
extends RelTraitDef<RelCollation> {
    public static final RelCollationTraitDef INSTANCE = new RelCollationTraitDef();

    private RelCollationTraitDef() {
    }

    @Override
    public Class<RelCollation> getTraitClass() {
        return RelCollation.class;
    }

    @Override
    public String getSimpleName() {
        return "sort";
    }

    @Override
    public boolean multiple() {
        return true;
    }

    @Override
    public RelCollation getDefault() {
        return RelCollations.EMPTY;
    }

    @Override
    public RelNode convert(RelOptPlanner planner, RelNode rel, RelCollation toCollation, boolean allowInfiniteCostConverters) {
        if (toCollation.getFieldCollations().isEmpty()) {
            return null;
        }
        LogicalSort sort = LogicalSort.create(rel, toCollation, null, null);
        RelNode newRel = planner.register(sort, rel);
        RelTraitSet newTraitSet = rel.getTraitSet().replace(toCollation);
        if (!newRel.getTraitSet().equals(newTraitSet)) {
            newRel = planner.changeTraits(newRel, newTraitSet);
        }
        return newRel;
    }

    @Override
    public boolean canConvert(RelOptPlanner planner, RelCollation fromTrait, RelCollation toTrait) {
        return false;
    }

    @Override
    public boolean canConvert(RelOptPlanner planner, RelCollation fromTrait, RelCollation toTrait, RelNode fromRel) {
        for (RelFieldCollation field : toTrait.getFieldCollations()) {
            int index = field.getFieldIndex();
            if (index < fromRel.getRowType().getFieldCount()) continue;
            return false;
        }
        return true;
    }
}

