/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.roaringbitmap.buffer;

import org.apache.hive.druid.org.roaringbitmap.ShortIterator;
import org.apache.hive.druid.org.roaringbitmap.buffer.BufferUtil;
import org.apache.hive.druid.org.roaringbitmap.buffer.MappeableRunContainer;

final class MappeableRunContainerShortIterator
implements ShortIterator {
    int pos;
    int le = 0;
    int maxlength;
    int base;
    MappeableRunContainer parent;

    MappeableRunContainerShortIterator() {
    }

    MappeableRunContainerShortIterator(MappeableRunContainer p) {
        this.wrap(p);
    }

    void wrap(MappeableRunContainer p) {
        this.parent = p;
        this.pos = 0;
        this.le = 0;
        if (this.pos < this.parent.nbrruns) {
            this.maxlength = BufferUtil.toIntUnsigned(this.parent.getLength(this.pos));
            this.base = BufferUtil.toIntUnsigned(this.parent.getValue(this.pos));
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.parent.nbrruns;
    }

    @Override
    public ShortIterator clone() {
        try {
            return (ShortIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public short next() {
        short ans = (short)(this.base + this.le);
        ++this.le;
        if (this.le > this.maxlength) {
            ++this.pos;
            this.le = 0;
            if (this.pos < this.parent.nbrruns) {
                this.maxlength = BufferUtil.toIntUnsigned(this.parent.getLength(this.pos));
                this.base = BufferUtil.toIntUnsigned(this.parent.getValue(this.pos));
            }
        }
        return ans;
    }

    @Override
    public int nextAsInt() {
        int ans = this.base + this.le;
        ++this.le;
        if (this.le > this.maxlength) {
            ++this.pos;
            this.le = 0;
            if (this.pos < this.parent.nbrruns) {
                this.maxlength = BufferUtil.toIntUnsigned(this.parent.getLength(this.pos));
                this.base = BufferUtil.toIntUnsigned(this.parent.getValue(this.pos));
            }
        }
        return ans;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }
}

