/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid;

import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.druid.DerbyConnectorTestUtility;
import org.apache.hadoop.hive.druid.DruidStorageHandler;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.indexer.JobHelper;
import org.apache.hive.druid.io.druid.indexer.SQLMetadataStorageUpdaterJobHandler;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.io.druid.segment.loading.DataSegmentPusher;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.io.druid.storage.hdfs.HdfsDataSegmentPusher;
import org.apache.hive.druid.io.druid.storage.hdfs.HdfsDataSegmentPusherConfig;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.LinearShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class TestDruidStorageHandler {
    @Rule
    public final DerbyConnectorTestUtility.DerbyConnectorRule derbyConnectorRule = new DerbyConnectorTestUtility.DerbyConnectorRule();
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static final String DB_NAME = "default";
    private static final String TABLE_NAME = "testName";
    private static final String DATA_SOURCE_NAME = "default.testName";
    private String segmentsTable;
    private String tableWorkingPath;
    private Configuration config;
    private DruidStorageHandler druidStorageHandler;
    Table tableMock = (Table)Mockito.mock(Table.class);

    private DataSegment createSegment(String location) throws IOException {
        return this.createSegment(location, new Interval(100L, 170L, DateTimeZone.UTC), "v1", (ShardSpec)new LinearShardSpec(Integer.valueOf(0)));
    }

    private DataSegment createSegment(String location, Interval interval, String version, ShardSpec shardSpec) throws IOException {
        FileUtils.writeStringToFile((File)new File(location), (String)"dummySegmentData");
        DataSegment dataSegment = DataSegment.builder().dataSource(DATA_SOURCE_NAME).version(version).interval(interval).shardSpec(shardSpec).loadSpec((Map)ImmutableMap.of((Object)"path", (Object)location)).build();
        return dataSegment;
    }

    @Before
    public void before() throws Throwable {
        this.tableWorkingPath = this.temporaryFolder.newFolder().getAbsolutePath();
        this.segmentsTable = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable();
        Mockito.when((Object)this.tableMock.getParameters()).thenReturn(new HashMap());
        Mockito.when((Object)this.tableMock.getPartitionKeysSize()).thenReturn((Object)0);
        StorageDescriptor storageDes = (StorageDescriptor)Mockito.mock(StorageDescriptor.class);
        Mockito.when((Object)storageDes.getBucketColsSize()).thenReturn((Object)0);
        Mockito.when((Object)this.tableMock.getSd()).thenReturn((Object)storageDes);
        Mockito.when((Object)this.tableMock.getDbName()).thenReturn((Object)DB_NAME);
        Mockito.when((Object)this.tableMock.getTableName()).thenReturn((Object)TABLE_NAME);
        this.config = new Configuration();
        this.config.set(String.valueOf(HiveConf.ConfVars.HIVEQUERYID), "hive-" + UUID.randomUUID().toString());
        this.config.set(String.valueOf(HiveConf.ConfVars.DRUID_WORKING_DIR), this.tableWorkingPath);
        this.config.set(String.valueOf(HiveConf.ConfVars.DRUID_SEGMENT_DIRECTORY), new Path(this.tableWorkingPath, "finalSegmentDir").toString());
        this.config.set("hive.druid.maxTries", "0");
        this.druidStorageHandler = new DruidStorageHandler((SQLMetadataConnector)this.derbyConnectorRule.getConnector(), (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get());
        this.druidStorageHandler.setConf(this.config);
    }

    @After
    public void tearDown() {
        this.temporaryFolder.delete();
    }

    @Test
    public void testPreCreateTableWillCreateSegmentsTable() throws MetaException {
        try (Handle handle = this.derbyConnectorRule.getConnector().getDBI().open();){
            Assert.assertFalse((boolean)this.derbyConnectorRule.getConnector().tableExists(handle, this.segmentsTable));
            this.druidStorageHandler.preCreateTable(this.tableMock);
            Assert.assertTrue((boolean)this.derbyConnectorRule.getConnector().tableExists(handle, this.segmentsTable));
        }
    }

    @Test(expected=MetaException.class)
    public void testPreCreateTableWhenDataSourceExists() throws MetaException, IOException {
        this.derbyConnectorRule.getConnector().createSegmentTable();
        SQLMetadataStorageUpdaterJobHandler sqlMetadataStorageUpdaterJobHandler = new SQLMetadataStorageUpdaterJobHandler((SQLMetadataConnector)this.derbyConnectorRule.getConnector());
        Path taskDirPath = new Path(this.tableWorkingPath, this.druidStorageHandler.makeStagingName());
        DataSegment dataSegment = this.createSegment(new Path(taskDirPath, "intermediatePath").toString());
        sqlMetadataStorageUpdaterJobHandler.publishSegments(this.segmentsTable, Arrays.asList(dataSegment), DruidStorageHandlerUtils.JSON_MAPPER);
        this.druidStorageHandler.preCreateTable(this.tableMock);
    }

    @Test
    public void testCommitCreateTablePlusCommitDropTableWithoutPurge() throws MetaException, IOException {
        this.druidStorageHandler.preCreateTable(this.tableMock);
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)this.config);
        Path taskDirPath = new Path(this.tableWorkingPath, this.druidStorageHandler.makeStagingName());
        DataSegment dataSegment = this.createSegment(new Path(taskDirPath, "index.zip").toString());
        Path descriptorPath = DruidStorageHandlerUtils.makeSegmentDescriptorOutputPath((DataSegment)dataSegment, (Path)new Path(taskDirPath, "segmentsDescriptorDir"));
        DruidStorageHandlerUtils.writeSegmentDescriptor((FileSystem)localFileSystem, (DataSegment)dataSegment, (Path)descriptorPath);
        this.druidStorageHandler.commitCreateTable(this.tableMock);
        Assert.assertArrayEquals((Object[])Lists.newArrayList((Object[])new String[]{DATA_SOURCE_NAME}).toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)this.derbyConnectorRule.getConnector(), (MetadataStorageTablesConfig)((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()))).toArray());
        this.druidStorageHandler.commitDropTable(this.tableMock, false);
        Assert.assertArrayEquals((Object[])Lists.newArrayList().toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)this.derbyConnectorRule.getConnector(), (MetadataStorageTablesConfig)((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()))).toArray());
    }

    @Test
    public void testCommitCreateTablePlusCommitDropTableWithPurge() throws MetaException, IOException {
        this.druidStorageHandler.preCreateTable(this.tableMock);
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)this.config);
        Path taskDirPath = new Path(this.tableWorkingPath, this.druidStorageHandler.makeStagingName());
        DataSegment dataSegment = this.createSegment(new Path(taskDirPath, "index.zip").toString());
        Path descriptorPath = DruidStorageHandlerUtils.makeSegmentDescriptorOutputPath((DataSegment)dataSegment, (Path)new Path(taskDirPath, "segmentsDescriptorDir"));
        DruidStorageHandlerUtils.writeSegmentDescriptor((FileSystem)localFileSystem, (DataSegment)dataSegment, (Path)descriptorPath);
        this.druidStorageHandler.commitCreateTable(this.tableMock);
        Assert.assertArrayEquals((Object[])Lists.newArrayList((Object[])new String[]{DATA_SOURCE_NAME}).toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)this.derbyConnectorRule.getConnector(), (MetadataStorageTablesConfig)((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()))).toArray());
        this.druidStorageHandler.commitDropTable(this.tableMock, true);
        Assert.assertArrayEquals((Object[])Lists.newArrayList().toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)this.derbyConnectorRule.getConnector(), (MetadataStorageTablesConfig)((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()))).toArray());
    }

    @Test
    public void testCommitCreateEmptyTablePlusCommitDropTableWithoutPurge() throws MetaException, IOException {
        this.druidStorageHandler.preCreateTable(this.tableMock);
        this.druidStorageHandler.commitCreateTable(this.tableMock);
        Assert.assertArrayEquals((Object[])Lists.newArrayList().toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)this.derbyConnectorRule.getConnector(), (MetadataStorageTablesConfig)((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()))).toArray());
        this.druidStorageHandler.commitDropTable(this.tableMock, false);
        Assert.assertArrayEquals((Object[])Lists.newArrayList().toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)this.derbyConnectorRule.getConnector(), (MetadataStorageTablesConfig)((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()))).toArray());
    }

    @Test
    public void testCommitCreateEmptyTablePlusCommitDropTableWithPurge() throws MetaException, IOException {
        this.druidStorageHandler.preCreateTable(this.tableMock);
        this.druidStorageHandler.commitCreateTable(this.tableMock);
        Assert.assertArrayEquals((Object[])Lists.newArrayList().toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)this.derbyConnectorRule.getConnector(), (MetadataStorageTablesConfig)((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()))).toArray());
        this.druidStorageHandler.commitDropTable(this.tableMock, true);
        Assert.assertArrayEquals((Object[])Lists.newArrayList().toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)this.derbyConnectorRule.getConnector(), (MetadataStorageTablesConfig)((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()))).toArray());
    }

    @Test
    public void testCommitInsertTable() throws MetaException, IOException {
        this.druidStorageHandler.preCreateTable(this.tableMock);
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)this.config);
        Path taskDirPath = new Path(this.tableWorkingPath, this.druidStorageHandler.makeStagingName());
        DataSegment dataSegment = this.createSegment(new Path(taskDirPath, "index.zip").toString());
        Path descriptorPath = DruidStorageHandlerUtils.makeSegmentDescriptorOutputPath((DataSegment)dataSegment, (Path)new Path(taskDirPath, "segmentsDescriptorDir"));
        DruidStorageHandlerUtils.writeSegmentDescriptor((FileSystem)localFileSystem, (DataSegment)dataSegment, (Path)descriptorPath);
        this.druidStorageHandler.commitCreateTable(this.tableMock);
        Assert.assertArrayEquals((Object[])Lists.newArrayList((Object[])new String[]{DATA_SOURCE_NAME}).toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)this.derbyConnectorRule.getConnector(), (MetadataStorageTablesConfig)((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()))).toArray());
    }

    @Test
    public void testCommitEmptyInsertTable() throws MetaException, IOException {
        this.druidStorageHandler.preCreateTable(this.tableMock);
        this.druidStorageHandler.commitCreateTable(this.tableMock);
        Assert.assertArrayEquals((Object[])Lists.newArrayList().toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)this.derbyConnectorRule.getConnector(), (MetadataStorageTablesConfig)((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()))).toArray());
    }

    @Test
    public void testDeleteSegment() throws IOException, SegmentLoadingException {
        String segmentRootPath = this.temporaryFolder.newFolder().getAbsolutePath();
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)this.config);
        Path taskDirPath = new Path(this.tableWorkingPath, this.druidStorageHandler.makeStagingName());
        DataSegment dataSegment = this.createSegment(new Path(taskDirPath, "index.zip").toString());
        HdfsDataSegmentPusherConfig hdfsDSPConfig = new HdfsDataSegmentPusherConfig();
        hdfsDSPConfig.setStorageDirectory(segmentRootPath);
        HdfsDataSegmentPusher hdfsDataSegmentPusher = new HdfsDataSegmentPusher(hdfsDSPConfig, this.config, DruidStorageHandlerUtils.JSON_MAPPER);
        Path segmentOutputPath = JobHelper.makeFileNamePath((Path)new Path(segmentRootPath), (FileSystem)localFileSystem, (DataSegment)dataSegment, (String)"index.zip", (DataSegmentPusher)hdfsDataSegmentPusher);
        Path indexPath = new Path(segmentOutputPath, "index.zip");
        DataSegment dataSegmentWithLoadspect = DataSegment.builder((DataSegment)dataSegment).loadSpec((Map)ImmutableMap.of((Object)"path", (Object)indexPath)).build();
        FSDataOutputStream outputStream = localFileSystem.create(indexPath, true);
        outputStream.close();
        Assert.assertTrue((String)"index file is not created ??", (boolean)localFileSystem.exists(indexPath));
        Assert.assertTrue((boolean)localFileSystem.exists(segmentOutputPath));
        this.druidStorageHandler.deleteSegment(dataSegmentWithLoadspect);
        Assert.assertFalse((String)"Index file still there ??", (boolean)localFileSystem.exists(indexPath));
        Assert.assertFalse((String)"PartitionNum directory still there ??", (boolean)localFileSystem.exists(segmentOutputPath));
        Assert.assertFalse((String)"Version directory still there ??", (boolean)localFileSystem.exists(segmentOutputPath.getParent()));
        Assert.assertFalse((String)"Interval directory still there ??", (boolean)localFileSystem.exists(segmentOutputPath.getParent().getParent()));
        Assert.assertFalse((String)"Data source directory still there ??", (boolean)localFileSystem.exists(segmentOutputPath.getParent().getParent().getParent()));
    }

    @Test
    public void testCommitInsertOverwriteTable() throws MetaException, IOException {
        DerbyConnectorTestUtility connector = this.derbyConnectorRule.getConnector();
        MetadataStorageTablesConfig metadataStorageTablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        this.druidStorageHandler.preCreateTable(this.tableMock);
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)this.config);
        Path taskDirPath = new Path(this.tableWorkingPath, this.druidStorageHandler.makeStagingName());
        HdfsDataSegmentPusherConfig pusherConfig = new HdfsDataSegmentPusherConfig();
        pusherConfig.setStorageDirectory(this.config.get(String.valueOf(HiveConf.ConfVars.DRUID_SEGMENT_DIRECTORY)));
        HdfsDataSegmentPusher dataSegmentPusher = new HdfsDataSegmentPusher(pusherConfig, this.config, DruidStorageHandlerUtils.JSON_MAPPER);
        List<DataSegment> existingSegments = Arrays.asList(this.createSegment(new Path(taskDirPath, "index.zip").toString(), new Interval(100L, 150L, DateTimeZone.UTC), "v0", (ShardSpec)new LinearShardSpec(Integer.valueOf(0))));
        DruidStorageHandlerUtils.publishSegmentsAndCommit((SQLMetadataConnector)connector, (MetadataStorageTablesConfig)metadataStorageTablesConfig, (String)DATA_SOURCE_NAME, existingSegments, (boolean)true, (Configuration)this.config, (DataSegmentPusher)dataSegmentPusher);
        DataSegment dataSegment = this.createSegment(new Path(taskDirPath, "index.zip").toString(), new Interval(180L, 250L, DateTimeZone.UTC), "v1", (ShardSpec)new LinearShardSpec(Integer.valueOf(0)));
        Path descriptorPath = DruidStorageHandlerUtils.makeSegmentDescriptorOutputPath((DataSegment)dataSegment, (Path)new Path(taskDirPath, "segmentsDescriptorDir"));
        DruidStorageHandlerUtils.writeSegmentDescriptor((FileSystem)localFileSystem, (DataSegment)dataSegment, (Path)descriptorPath);
        this.druidStorageHandler.commitInsertTable(this.tableMock, true);
        Assert.assertArrayEquals((Object[])Lists.newArrayList((Object[])new String[]{DATA_SOURCE_NAME}).toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)connector, (MetadataStorageTablesConfig)metadataStorageTablesConfig)).toArray());
        List<DataSegment> dataSegmentList = this.getUsedSegmentsList(connector, metadataStorageTablesConfig);
        Assert.assertEquals((long)1L, (long)dataSegmentList.size());
        DataSegment persistedSegment = (DataSegment)Iterables.getOnlyElement(dataSegmentList);
        Assert.assertEquals((Object)dataSegment, (Object)persistedSegment);
        Assert.assertEquals((Object)dataSegment.getVersion(), (Object)persistedSegment.getVersion());
        Path expectedFinalHadoopPath = new Path(dataSegmentPusher.getPathForHadoop(), dataSegmentPusher.makeIndexPathName(persistedSegment, "index.zip"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"type", (Object)"hdfs", (Object)"path", (Object)expectedFinalHadoopPath.toString()), (Object)persistedSegment.getLoadSpec());
        Assert.assertEquals((Object)"dummySegmentData", (Object)FileUtils.readFileToString((File)new File(expectedFinalHadoopPath.toUri())));
    }

    @Test
    public void testCommitMultiInsertOverwriteTable() throws MetaException, IOException {
        DerbyConnectorTestUtility connector = this.derbyConnectorRule.getConnector();
        MetadataStorageTablesConfig metadataStorageTablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)this.config);
        this.druidStorageHandler.preCreateTable(this.tableMock);
        Path taskDirPath = new Path(this.tableWorkingPath, this.druidStorageHandler.makeStagingName());
        HdfsDataSegmentPusherConfig pusherConfig = new HdfsDataSegmentPusherConfig();
        pusherConfig.setStorageDirectory(this.config.get(String.valueOf(HiveConf.ConfVars.DRUID_SEGMENT_DIRECTORY)));
        HdfsDataSegmentPusher dataSegmentPusher = new HdfsDataSegmentPusher(pusherConfig, this.config, DruidStorageHandlerUtils.JSON_MAPPER);
        List<DataSegment> existingSegments = Arrays.asList(this.createSegment(new Path(taskDirPath, "index.zip").toString(), new Interval(100L, 150L, DateTimeZone.UTC), "v0", (ShardSpec)new LinearShardSpec(Integer.valueOf(0))));
        DruidStorageHandlerUtils.publishSegmentsAndCommit((SQLMetadataConnector)connector, (MetadataStorageTablesConfig)metadataStorageTablesConfig, (String)DATA_SOURCE_NAME, existingSegments, (boolean)true, (Configuration)this.config, (DataSegmentPusher)dataSegmentPusher);
        Assert.assertArrayEquals((Object[])Lists.newArrayList((Object[])new String[]{DATA_SOURCE_NAME}).toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)connector, (MetadataStorageTablesConfig)metadataStorageTablesConfig)).toArray());
        this.druidStorageHandler.commitInsertTable(this.tableMock, false);
        Assert.assertArrayEquals((Object[])Lists.newArrayList((Object[])new String[]{DATA_SOURCE_NAME}).toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)connector, (MetadataStorageTablesConfig)metadataStorageTablesConfig)).toArray());
        Assert.assertEquals((long)1L, (long)this.getUsedSegmentsList(connector, metadataStorageTablesConfig).size());
        this.druidStorageHandler.commitInsertTable(this.tableMock, true);
        Assert.assertEquals((long)0L, (long)this.getUsedSegmentsList(connector, metadataStorageTablesConfig).size());
        this.druidStorageHandler.commitInsertTable(this.tableMock, true);
        Assert.assertEquals((long)0L, (long)this.getUsedSegmentsList(connector, metadataStorageTablesConfig).size());
        this.druidStorageHandler.commitInsertTable(this.tableMock, true);
        Assert.assertEquals((long)0L, (long)this.getUsedSegmentsList(connector, metadataStorageTablesConfig).size());
        DataSegment dataSegment1 = this.createSegment(new Path(taskDirPath, "index.zip").toString(), new Interval(180L, 250L, DateTimeZone.UTC), "v1", (ShardSpec)new LinearShardSpec(Integer.valueOf(0)));
        Path descriptorPath1 = DruidStorageHandlerUtils.makeSegmentDescriptorOutputPath((DataSegment)dataSegment1, (Path)new Path(taskDirPath, "segmentsDescriptorDir"));
        DruidStorageHandlerUtils.writeSegmentDescriptor((FileSystem)localFileSystem, (DataSegment)dataSegment1, (Path)descriptorPath1);
        this.druidStorageHandler.commitInsertTable(this.tableMock, false);
        Assert.assertArrayEquals((Object[])Lists.newArrayList((Object[])new String[]{DATA_SOURCE_NAME}).toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)connector, (MetadataStorageTablesConfig)metadataStorageTablesConfig)).toArray());
        Assert.assertEquals((long)1L, (long)this.getUsedSegmentsList(connector, metadataStorageTablesConfig).size());
        DataSegment dataSegment2 = this.createSegment(new Path(taskDirPath, "index.zip").toString(), new Interval(200L, 250L, DateTimeZone.UTC), "v1", (ShardSpec)new LinearShardSpec(Integer.valueOf(0)));
        Path descriptorPath2 = DruidStorageHandlerUtils.makeSegmentDescriptorOutputPath((DataSegment)dataSegment2, (Path)new Path(taskDirPath, "segmentsDescriptorDir"));
        DruidStorageHandlerUtils.writeSegmentDescriptor((FileSystem)localFileSystem, (DataSegment)dataSegment2, (Path)descriptorPath2);
        this.druidStorageHandler.commitInsertTable(this.tableMock, true);
        Assert.assertArrayEquals((Object[])Lists.newArrayList((Object[])new String[]{DATA_SOURCE_NAME}).toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)connector, (MetadataStorageTablesConfig)metadataStorageTablesConfig)).toArray());
        Assert.assertEquals((long)1L, (long)this.getUsedSegmentsList(connector, metadataStorageTablesConfig).size());
        DataSegment dataSegment3 = this.createSegment(new Path(taskDirPath, "index.zip").toString(), new Interval(100L, 200L, DateTimeZone.UTC), "v1", (ShardSpec)new LinearShardSpec(Integer.valueOf(0)));
        Path descriptorPath3 = DruidStorageHandlerUtils.makeSegmentDescriptorOutputPath((DataSegment)dataSegment3, (Path)new Path(taskDirPath, "segmentsDescriptorDir"));
        DruidStorageHandlerUtils.writeSegmentDescriptor((FileSystem)localFileSystem, (DataSegment)dataSegment3, (Path)descriptorPath3);
        this.druidStorageHandler.commitInsertTable(this.tableMock, false);
        Assert.assertArrayEquals((Object[])Lists.newArrayList((Object[])new String[]{DATA_SOURCE_NAME}).toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)connector, (MetadataStorageTablesConfig)metadataStorageTablesConfig)).toArray());
        Assert.assertEquals((long)2L, (long)this.getUsedSegmentsList(connector, metadataStorageTablesConfig).size());
        this.druidStorageHandler.commitInsertTable(this.tableMock, true);
        Assert.assertEquals((long)0L, (long)this.getUsedSegmentsList(connector, metadataStorageTablesConfig).size());
    }

    private List<DataSegment> getUsedSegmentsList(DerbyConnectorTestUtility connector, final MetadataStorageTablesConfig metadataStorageTablesConfig) {
        return (List)connector.getDBI().withHandle((HandleCallback)new HandleCallback<List<DataSegment>>(){

            public List<DataSegment> withHandle(Handle handle) throws Exception {
                return handle.createQuery(String.format("SELECT payload FROM %s WHERE used=true ORDER BY created_date ASC", metadataStorageTablesConfig.getSegmentsTable())).map((ResultSetMapper)new ResultSetMapper<DataSegment>(){

                    public DataSegment map(int i, ResultSet resultSet, StatementContext statementContext) throws SQLException {
                        try {
                            return (DataSegment)DruidStorageHandlerUtils.JSON_MAPPER.readValue(resultSet.getBytes("payload"), DataSegment.class);
                        }
                        catch (IOException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                    }
                }).list();
            }
        });
    }

    @Test
    public void testCommitInsertIntoTable() throws MetaException, IOException {
        DerbyConnectorTestUtility connector = this.derbyConnectorRule.getConnector();
        MetadataStorageTablesConfig metadataStorageTablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        this.druidStorageHandler.preCreateTable(this.tableMock);
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)this.config);
        Path taskDirPath = new Path(this.tableWorkingPath, this.druidStorageHandler.makeStagingName());
        List<DataSegment> existingSegments = Arrays.asList(this.createSegment(new Path(taskDirPath, "index.zip").toString(), new Interval(100L, 150L, DateTimeZone.UTC), "v0", (ShardSpec)new LinearShardSpec(Integer.valueOf(1))));
        HdfsDataSegmentPusherConfig pusherConfig = new HdfsDataSegmentPusherConfig();
        pusherConfig.setStorageDirectory(this.config.get(String.valueOf(HiveConf.ConfVars.DRUID_SEGMENT_DIRECTORY)));
        HdfsDataSegmentPusher dataSegmentPusher = new HdfsDataSegmentPusher(pusherConfig, this.config, DruidStorageHandlerUtils.JSON_MAPPER);
        DruidStorageHandlerUtils.publishSegmentsAndCommit((SQLMetadataConnector)connector, (MetadataStorageTablesConfig)metadataStorageTablesConfig, (String)DATA_SOURCE_NAME, existingSegments, (boolean)true, (Configuration)this.config, (DataSegmentPusher)dataSegmentPusher);
        DataSegment dataSegment = this.createSegment(new Path(taskDirPath, "index.zip").toString(), new Interval(100L, 150L, DateTimeZone.UTC), "v1", (ShardSpec)new LinearShardSpec(Integer.valueOf(0)));
        Path descriptorPath = DruidStorageHandlerUtils.makeSegmentDescriptorOutputPath((DataSegment)dataSegment, (Path)new Path(taskDirPath, "segmentsDescriptorDir"));
        DruidStorageHandlerUtils.writeSegmentDescriptor((FileSystem)localFileSystem, (DataSegment)dataSegment, (Path)descriptorPath);
        this.druidStorageHandler.commitInsertTable(this.tableMock, false);
        Assert.assertArrayEquals((Object[])Lists.newArrayList((Object[])new String[]{DATA_SOURCE_NAME}).toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)connector, (MetadataStorageTablesConfig)metadataStorageTablesConfig)).toArray());
        List<DataSegment> dataSegmentList = this.getUsedSegmentsList(connector, metadataStorageTablesConfig);
        Assert.assertEquals((long)2L, (long)dataSegmentList.size());
        DataSegment persistedSegment = dataSegmentList.get(1);
        Assert.assertEquals((Object)"v0", (Object)persistedSegment.getVersion());
        Assert.assertTrue((boolean)(persistedSegment.getShardSpec() instanceof LinearShardSpec));
        Assert.assertEquals((long)2L, (long)persistedSegment.getShardSpec().getPartitionNum());
        Path expectedFinalHadoopPath = new Path(dataSegmentPusher.getPathForHadoop(), dataSegmentPusher.makeIndexPathName(persistedSegment, "index.zip"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"type", (Object)"hdfs", (Object)"path", (Object)expectedFinalHadoopPath.toString()), (Object)persistedSegment.getLoadSpec());
        Assert.assertEquals((Object)"dummySegmentData", (Object)FileUtils.readFileToString((File)new File(expectedFinalHadoopPath.toUri())));
    }

    @Test
    public void testInsertIntoAppendOneMorePartition() throws MetaException, IOException {
        DerbyConnectorTestUtility connector = this.derbyConnectorRule.getConnector();
        MetadataStorageTablesConfig metadataStorageTablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        this.druidStorageHandler.preCreateTable(this.tableMock);
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)this.config);
        Path taskDirPath = new Path(this.tableWorkingPath, this.druidStorageHandler.makeStagingName());
        HdfsDataSegmentPusherConfig pusherConfig = new HdfsDataSegmentPusherConfig();
        pusherConfig.setStorageDirectory(this.config.get(String.valueOf(HiveConf.ConfVars.DRUID_SEGMENT_DIRECTORY)));
        HdfsDataSegmentPusher dataSegmentPusher = new HdfsDataSegmentPusher(pusherConfig, this.config, DruidStorageHandlerUtils.JSON_MAPPER);
        List<DataSegment> existingSegments = Arrays.asList(this.createSegment(new Path(taskDirPath, "index.zip").toString(), new Interval(100L, 150L, DateTimeZone.UTC), "v0", (ShardSpec)new LinearShardSpec(Integer.valueOf(0))));
        DruidStorageHandlerUtils.publishSegmentsAndCommit((SQLMetadataConnector)connector, (MetadataStorageTablesConfig)metadataStorageTablesConfig, (String)DATA_SOURCE_NAME, existingSegments, (boolean)true, (Configuration)this.config, (DataSegmentPusher)dataSegmentPusher);
        DataSegment dataSegment = this.createSegment(new Path(taskDirPath, "index.zip").toString(), new Interval(100L, 150L, DateTimeZone.UTC), "v0", (ShardSpec)new LinearShardSpec(Integer.valueOf(0)));
        Path descriptorPath = DruidStorageHandlerUtils.makeSegmentDescriptorOutputPath((DataSegment)dataSegment, (Path)new Path(taskDirPath, "segmentsDescriptorDir"));
        DruidStorageHandlerUtils.writeSegmentDescriptor((FileSystem)localFileSystem, (DataSegment)dataSegment, (Path)descriptorPath);
        this.druidStorageHandler.commitInsertTable(this.tableMock, false);
        Assert.assertArrayEquals((Object[])Lists.newArrayList((Object[])new String[]{DATA_SOURCE_NAME}).toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)connector, (MetadataStorageTablesConfig)metadataStorageTablesConfig)).toArray());
        List<DataSegment> dataSegmentList = this.getUsedSegmentsList(connector, metadataStorageTablesConfig);
        Assert.assertEquals((long)2L, (long)dataSegmentList.size());
        DataSegment persistedSegment = dataSegmentList.get(1);
        Assert.assertEquals((Object)"v0", (Object)persistedSegment.getVersion());
        Assert.assertTrue((boolean)(persistedSegment.getShardSpec() instanceof LinearShardSpec));
        Assert.assertEquals((long)1L, (long)persistedSegment.getShardSpec().getPartitionNum());
        Path expectedFinalHadoopPath = new Path(dataSegmentPusher.getPathForHadoop(), dataSegmentPusher.makeIndexPathName(persistedSegment, "index.zip"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"type", (Object)"hdfs", (Object)"path", (Object)expectedFinalHadoopPath.toString()), (Object)persistedSegment.getLoadSpec());
        Assert.assertEquals((Object)"dummySegmentData", (Object)FileUtils.readFileToString((File)new File(expectedFinalHadoopPath.toUri())));
    }

    @Test
    public void testCommitInsertIntoWhenDestinationSegmentFileExist() throws MetaException, IOException {
        DerbyConnectorTestUtility connector = this.derbyConnectorRule.getConnector();
        MetadataStorageTablesConfig metadataStorageTablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        this.druidStorageHandler.preCreateTable(this.tableMock);
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)this.config);
        Path taskDirPath = new Path(this.tableWorkingPath, this.druidStorageHandler.makeStagingName());
        List<DataSegment> existingSegments = Arrays.asList(this.createSegment(new Path(taskDirPath, "index_old.zip").toString(), new Interval(100L, 150L, DateTimeZone.UTC), "v0", (ShardSpec)new LinearShardSpec(Integer.valueOf(1))));
        HdfsDataSegmentPusherConfig pusherConfig = new HdfsDataSegmentPusherConfig();
        pusherConfig.setStorageDirectory(this.config.get(String.valueOf(HiveConf.ConfVars.DRUID_SEGMENT_DIRECTORY)));
        HdfsDataSegmentPusher dataSegmentPusher = new HdfsDataSegmentPusher(pusherConfig, this.config, DruidStorageHandlerUtils.JSON_MAPPER);
        DruidStorageHandlerUtils.publishSegmentsAndCommit((SQLMetadataConnector)connector, (MetadataStorageTablesConfig)metadataStorageTablesConfig, (String)DATA_SOURCE_NAME, existingSegments, (boolean)true, (Configuration)this.config, (DataSegmentPusher)dataSegmentPusher);
        DataSegment dataSegment = this.createSegment(new Path(taskDirPath, "index.zip").toString(), new Interval(100L, 150L, DateTimeZone.UTC), "v1", (ShardSpec)new LinearShardSpec(Integer.valueOf(0)));
        Path descriptorPath = DruidStorageHandlerUtils.makeSegmentDescriptorOutputPath((DataSegment)dataSegment, (Path)new Path(taskDirPath, "segmentsDescriptorDir"));
        DruidStorageHandlerUtils.writeSegmentDescriptor((FileSystem)localFileSystem, (DataSegment)dataSegment, (Path)descriptorPath);
        DataSegment segment = this.createSegment(new Path(taskDirPath, "index_conflict.zip").toString(), new Interval(100L, 150L, DateTimeZone.UTC), "v1", (ShardSpec)new LinearShardSpec(Integer.valueOf(1)));
        Path segmentPath = new Path(dataSegmentPusher.getPathForHadoop(), dataSegmentPusher.makeIndexPathName(segment, "index.zip"));
        FileUtils.writeStringToFile((File)new File(segmentPath.toUri()), (String)"dummy");
        this.druidStorageHandler.commitInsertTable(this.tableMock, false);
        Assert.assertArrayEquals((Object[])Lists.newArrayList((Object[])new String[]{DATA_SOURCE_NAME}).toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)connector, (MetadataStorageTablesConfig)metadataStorageTablesConfig)).toArray());
        List<DataSegment> dataSegmentList = this.getUsedSegmentsList(connector, metadataStorageTablesConfig);
        Assert.assertEquals((long)2L, (long)dataSegmentList.size());
        DataSegment persistedSegment = dataSegmentList.get(1);
        Assert.assertEquals((Object)"v0", (Object)persistedSegment.getVersion());
        Assert.assertTrue((boolean)(persistedSegment.getShardSpec() instanceof LinearShardSpec));
        Assert.assertEquals((long)2L, (long)persistedSegment.getShardSpec().getPartitionNum());
        Path expectedFinalHadoopPath = new Path(dataSegmentPusher.getPathForHadoop(), dataSegmentPusher.makeIndexPathName(persistedSegment, "index.zip"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"type", (Object)"hdfs", (Object)"path", (Object)expectedFinalHadoopPath.toString()), (Object)persistedSegment.getLoadSpec());
        Assert.assertEquals((Object)"dummySegmentData", (Object)FileUtils.readFileToString((File)new File(expectedFinalHadoopPath.toUri())));
    }

    @Test(expected=MetaException.class)
    public void testCommitInsertIntoWithConflictingIntervalSegment() throws MetaException, IOException {
        DerbyConnectorTestUtility connector = this.derbyConnectorRule.getConnector();
        MetadataStorageTablesConfig metadataStorageTablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        this.druidStorageHandler.preCreateTable(this.tableMock);
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)this.config);
        Path taskDirPath = new Path(this.tableWorkingPath, this.druidStorageHandler.makeStagingName());
        List<DataSegment> existingSegments = Arrays.asList(this.createSegment(new Path(taskDirPath, "index_old_1.zip").toString(), new Interval(100L, 150L, DateTimeZone.UTC), "v0", (ShardSpec)new LinearShardSpec(Integer.valueOf(0))), this.createSegment(new Path(taskDirPath, "index_old_2.zip").toString(), new Interval(150L, 200L, DateTimeZone.UTC), "v0", (ShardSpec)new LinearShardSpec(Integer.valueOf(0))), this.createSegment(new Path(taskDirPath, "index_old_3.zip").toString(), new Interval(200L, 300L, DateTimeZone.UTC), "v0", (ShardSpec)new LinearShardSpec(Integer.valueOf(0))));
        HdfsDataSegmentPusherConfig pusherConfig = new HdfsDataSegmentPusherConfig();
        pusherConfig.setStorageDirectory(taskDirPath.toString());
        HdfsDataSegmentPusher dataSegmentPusher = new HdfsDataSegmentPusher(pusherConfig, this.config, DruidStorageHandlerUtils.JSON_MAPPER);
        DruidStorageHandlerUtils.publishSegmentsAndCommit((SQLMetadataConnector)connector, (MetadataStorageTablesConfig)metadataStorageTablesConfig, (String)DATA_SOURCE_NAME, existingSegments, (boolean)true, (Configuration)this.config, (DataSegmentPusher)dataSegmentPusher);
        DataSegment conflictingSegment = this.createSegment(new Path(taskDirPath, "index.zip").toString(), new Interval(100L, 300L, DateTimeZone.UTC), "v1", (ShardSpec)new LinearShardSpec(Integer.valueOf(0)));
        Path descriptorPath = DruidStorageHandlerUtils.makeSegmentDescriptorOutputPath((DataSegment)conflictingSegment, (Path)new Path(taskDirPath, "segmentsDescriptorDir"));
        DruidStorageHandlerUtils.writeSegmentDescriptor((FileSystem)localFileSystem, (DataSegment)conflictingSegment, (Path)descriptorPath);
        this.druidStorageHandler.commitInsertTable(this.tableMock, false);
    }

    @Test(expected=MetaException.class)
    public void testCommitInsertIntoWithNonExtendableSegment() throws MetaException, IOException {
        DerbyConnectorTestUtility connector = this.derbyConnectorRule.getConnector();
        MetadataStorageTablesConfig metadataStorageTablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        this.druidStorageHandler.preCreateTable(this.tableMock);
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)this.config);
        Path taskDirPath = new Path(this.tableWorkingPath, this.druidStorageHandler.makeStagingName());
        List<DataSegment> existingSegments = Arrays.asList(this.createSegment(new Path(taskDirPath, "index_old_1.zip").toString(), new Interval(100L, 150L, DateTimeZone.UTC), "v0", (ShardSpec)new NoneShardSpec()), this.createSegment(new Path(taskDirPath, "index_old_2.zip").toString(), new Interval(200L, 250L, DateTimeZone.UTC), "v0", (ShardSpec)new LinearShardSpec(Integer.valueOf(0))), this.createSegment(new Path(taskDirPath, "index_old_3.zip").toString(), new Interval(250L, 300L, DateTimeZone.UTC), "v0", (ShardSpec)new LinearShardSpec(Integer.valueOf(0))));
        HdfsDataSegmentPusherConfig pusherConfig = new HdfsDataSegmentPusherConfig();
        pusherConfig.setStorageDirectory(taskDirPath.toString());
        HdfsDataSegmentPusher dataSegmentPusher = new HdfsDataSegmentPusher(pusherConfig, this.config, DruidStorageHandlerUtils.JSON_MAPPER);
        DruidStorageHandlerUtils.publishSegmentsAndCommit((SQLMetadataConnector)connector, (MetadataStorageTablesConfig)metadataStorageTablesConfig, (String)DATA_SOURCE_NAME, existingSegments, (boolean)true, (Configuration)this.config, (DataSegmentPusher)dataSegmentPusher);
        DataSegment conflictingSegment = this.createSegment(new Path(taskDirPath, "index.zip").toString(), new Interval(100L, 150L, DateTimeZone.UTC), "v1", (ShardSpec)new LinearShardSpec(Integer.valueOf(0)));
        Path descriptorPath = DruidStorageHandlerUtils.makeSegmentDescriptorOutputPath((DataSegment)conflictingSegment, (Path)new Path(taskDirPath, "segmentsDescriptorDir"));
        DruidStorageHandlerUtils.writeSegmentDescriptor((FileSystem)localFileSystem, (DataSegment)conflictingSegment, (Path)descriptorPath);
        this.druidStorageHandler.commitInsertTable(this.tableMock, false);
    }
}

