/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.json;

import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.joda.time.Duration;
import org.joda.time.Period;

public class KafkaSupervisorIOConfig {
    public static final String BOOTSTRAP_SERVERS_KEY = "bootstrap.servers";
    private final String topic;
    private final Integer replicas;
    private final Integer taskCount;
    private final Duration taskDuration;
    private final Map<String, String> consumerProperties;
    private final Duration startDelay;
    private final Duration period;
    private final boolean useEarliestOffset;
    private final Duration completionTimeout;
    private final Optional<Duration> lateMessageRejectionPeriod;
    private final Optional<Duration> earlyMessageRejectionPeriod;
    private final boolean skipOffsetGaps;

    @JsonCreator
    public KafkaSupervisorIOConfig(@JsonProperty(value="topic") String topic, @JsonProperty(value="replicas") Integer replicas, @JsonProperty(value="taskCount") Integer taskCount, @JsonProperty(value="taskDuration") Period taskDuration, @JsonProperty(value="consumerProperties") Map<String, String> consumerProperties, @JsonProperty(value="startDelay") Period startDelay, @JsonProperty(value="period") Period period, @JsonProperty(value="useEarliestOffset") Boolean useEarliestOffset, @JsonProperty(value="completionTimeout") Period completionTimeout, @JsonProperty(value="lateMessageRejectionPeriod") Period lateMessageRejectionPeriod, @JsonProperty(value="earlyMessageRejectionPeriod") Period earlyMessageRejectionPeriod, @JsonProperty(value="skipOffsetGaps") Boolean skipOffsetGaps) {
        this.topic = Preconditions.checkNotNull(topic, "topic");
        this.consumerProperties = Preconditions.checkNotNull(consumerProperties, "consumerProperties");
        Preconditions.checkNotNull(consumerProperties.get(BOOTSTRAP_SERVERS_KEY), StringUtils.format("consumerProperties must contain entry for [%s]", BOOTSTRAP_SERVERS_KEY));
        this.replicas = replicas != null ? replicas : 1;
        this.taskCount = taskCount != null ? taskCount : 1;
        this.taskDuration = KafkaSupervisorIOConfig.defaultDuration(taskDuration, "PT1H");
        this.startDelay = KafkaSupervisorIOConfig.defaultDuration(startDelay, "PT5S");
        this.period = KafkaSupervisorIOConfig.defaultDuration(period, "PT30S");
        this.useEarliestOffset = useEarliestOffset != null ? useEarliestOffset : false;
        this.completionTimeout = KafkaSupervisorIOConfig.defaultDuration(completionTimeout, "PT30M");
        this.lateMessageRejectionPeriod = lateMessageRejectionPeriod == null ? Optional.absent() : Optional.of(lateMessageRejectionPeriod.toStandardDuration());
        this.earlyMessageRejectionPeriod = earlyMessageRejectionPeriod == null ? Optional.absent() : Optional.of(earlyMessageRejectionPeriod.toStandardDuration());
        this.skipOffsetGaps = skipOffsetGaps != null ? skipOffsetGaps : false;
    }

    @JsonProperty
    public String getTopic() {
        return this.topic;
    }

    @JsonProperty
    public Integer getReplicas() {
        return this.replicas;
    }

    @JsonProperty
    public Integer getTaskCount() {
        return this.taskCount;
    }

    @JsonProperty
    public Duration getTaskDuration() {
        return this.taskDuration;
    }

    @JsonProperty
    public Map<String, String> getConsumerProperties() {
        return this.consumerProperties;
    }

    @JsonProperty
    public Duration getStartDelay() {
        return this.startDelay;
    }

    @JsonProperty
    public Duration getPeriod() {
        return this.period;
    }

    @JsonProperty
    public boolean isUseEarliestOffset() {
        return this.useEarliestOffset;
    }

    @JsonProperty
    public Duration getCompletionTimeout() {
        return this.completionTimeout;
    }

    @JsonProperty
    public Optional<Duration> getEarlyMessageRejectionPeriod() {
        return this.earlyMessageRejectionPeriod;
    }

    @JsonProperty
    public Optional<Duration> getLateMessageRejectionPeriod() {
        return this.lateMessageRejectionPeriod;
    }

    @JsonProperty
    public boolean isSkipOffsetGaps() {
        return this.skipOffsetGaps;
    }

    public String toString() {
        return "KafkaSupervisorIOConfig{topic='" + this.topic + '\'' + ", replicas=" + this.replicas + ", taskCount=" + this.taskCount + ", taskDuration=" + this.taskDuration + ", consumerProperties=" + this.consumerProperties + ", startDelay=" + this.startDelay + ", period=" + this.period + ", useEarliestOffset=" + this.useEarliestOffset + ", completionTimeout=" + this.completionTimeout + ", lateMessageRejectionPeriod=" + this.lateMessageRejectionPeriod + ", skipOffsetGaps=" + this.skipOffsetGaps + '}';
    }

    private static Duration defaultDuration(Period period, String theDefault) {
        return (period == null ? new Period((Object)theDefault) : period).toStandardDuration();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaSupervisorIOConfig that = (KafkaSupervisorIOConfig)o;
        if (this.useEarliestOffset != that.useEarliestOffset) {
            return false;
        }
        if (this.skipOffsetGaps != that.skipOffsetGaps) {
            return false;
        }
        if (this.topic != null ? !this.topic.equals(that.topic) : that.topic != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.taskCount != null ? !this.taskCount.equals(that.taskCount) : that.taskCount != null) {
            return false;
        }
        if (this.taskDuration != null ? !this.taskDuration.equals((Object)that.taskDuration) : that.taskDuration != null) {
            return false;
        }
        if (this.consumerProperties != null ? !this.consumerProperties.equals(that.consumerProperties) : that.consumerProperties != null) {
            return false;
        }
        if (this.startDelay != null ? !this.startDelay.equals((Object)that.startDelay) : that.startDelay != null) {
            return false;
        }
        if (this.period != null ? !this.period.equals((Object)that.period) : that.period != null) {
            return false;
        }
        if (this.completionTimeout != null ? !this.completionTimeout.equals((Object)that.completionTimeout) : that.completionTimeout != null) {
            return false;
        }
        if (this.lateMessageRejectionPeriod != null ? !this.lateMessageRejectionPeriod.equals(that.lateMessageRejectionPeriod) : that.lateMessageRejectionPeriod != null) {
            return false;
        }
        return this.earlyMessageRejectionPeriod != null ? this.earlyMessageRejectionPeriod.equals(that.earlyMessageRejectionPeriod) : that.earlyMessageRejectionPeriod == null;
    }

    public int hashCode() {
        int result = this.topic != null ? this.topic.hashCode() : 0;
        result = 31 * result + (this.replicas != null ? this.replicas.hashCode() : 0);
        result = 31 * result + (this.taskCount != null ? this.taskCount.hashCode() : 0);
        result = 31 * result + (this.taskDuration != null ? this.taskDuration.hashCode() : 0);
        result = 31 * result + (this.consumerProperties != null ? this.consumerProperties.hashCode() : 0);
        result = 31 * result + (this.startDelay != null ? this.startDelay.hashCode() : 0);
        result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
        result = 31 * result + (this.useEarliestOffset ? 1 : 0);
        result = 31 * result + (this.completionTimeout != null ? this.completionTimeout.hashCode() : 0);
        result = 31 * result + (this.lateMessageRejectionPeriod != null ? this.lateMessageRejectionPeriod.hashCode() : 0);
        result = 31 * result + (this.earlyMessageRejectionPeriod != null ? this.earlyMessageRejectionPeriod.hashCode() : 0);
        result = 31 * result + (this.skipOffsetGaps ? 1 : 0);
        return result;
    }
}

