/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.serde;

import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DruidSerDeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DruidSerDeUtils.class);
    protected static final String ISO_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    protected static final String FLOAT_TYPE = "FLOAT";
    protected static final String DOUBLE_TYPE = "DOUBLE";
    protected static final String LONG_TYPE = "LONG";
    protected static final String STRING_TYPE = "STRING";

    public static PrimitiveTypeInfo convertDruidToHiveType(String typeName) {
        switch (typeName = typeName.toUpperCase()) {
            case "FLOAT": {
                return TypeInfoFactory.floatTypeInfo;
            }
            case "DOUBLE": {
                return TypeInfoFactory.doubleTypeInfo;
            }
            case "LONG": {
                return TypeInfoFactory.longTypeInfo;
            }
            case "STRING": {
                return TypeInfoFactory.stringTypeInfo;
            }
        }
        LOG.warn("Transformation to STRING for unknown type " + typeName);
        return TypeInfoFactory.stringTypeInfo;
    }
}

