/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common.collect;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class MoreIterators {
    public static <X> Iterator<X> bracket(Iterator<X> iterator, Runnable before, Runnable after) {
        return MoreIterators.before(MoreIterators.after(iterator, after), before);
    }

    public static <X> Iterator<X> before(final Iterator<X> iterator, final Runnable f) {
        return new Iterator<X>(){
            private final Runnable fOnlyOnce;
            {
                this.fOnlyOnce = new RunOnlyOnce(f);
            }

            @Override
            public boolean hasNext() {
                this.fOnlyOnce.run();
                return iterator.hasNext();
            }

            @Override
            public X next() {
                this.fOnlyOnce.run();
                return iterator.next();
            }

            @Override
            public void remove() {
                this.fOnlyOnce.run();
                iterator.remove();
            }
        };
    }

    public static <X> Iterator<X> after(final Iterator<X> iterator, final Runnable f) {
        return new Iterator<X>(){
            private final Runnable fOnlyOnce;
            {
                this.fOnlyOnce = new RunOnlyOnce(f);
            }

            @Override
            public boolean hasNext() {
                boolean hasNext = iterator.hasNext();
                if (!hasNext) {
                    this.fOnlyOnce.run();
                }
                return hasNext;
            }

            @Override
            public X next() {
                try {
                    return iterator.next();
                }
                catch (NoSuchElementException e) {
                    this.fOnlyOnce.run();
                    throw e;
                }
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    private static class RunOnlyOnce
    implements Runnable {
        private final Runnable f;
        private volatile boolean hasRun = false;

        public RunOnlyOnce(Runnable f) {
            this.f = f;
        }

        @Override
        public void run() {
            if (!this.hasRun) {
                this.f.run();
                this.hasRun = true;
            }
        }
    }
}

