/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client.coordinator;

import com.google.inject.Inject;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.io.druid.client.ImmutableSegmentLoadInfo;
import org.apache.hive.druid.io.druid.client.coordinator.Coordinator;
import org.apache.hive.druid.io.druid.discovery.DruidLeaderClient;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.http.client.response.FullResponseHolder;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.Interval;

public class CoordinatorClient {
    private final DruidLeaderClient druidLeaderClient;
    private final ObjectMapper jsonMapper;

    @Inject
    public CoordinatorClient(ObjectMapper jsonMapper, @Coordinator DruidLeaderClient druidLeaderClient) {
        this.jsonMapper = jsonMapper;
        this.druidLeaderClient = druidLeaderClient;
    }

    public List<ImmutableSegmentLoadInfo> fetchServerView(String dataSource, Interval interval, boolean incompleteOk) {
        try {
            FullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format("/druid/coordinator/v1/datasources/%s/intervals/%s/serverview?partial=%s", dataSource, interval.toString().replace("/", "_"), incompleteOk)));
            if (!response.getStatus().equals(HttpResponseStatus.OK)) {
                throw new ISE("Error while fetching serverView status[%s] content[%s]", response.getStatus(), response.getContent());
            }
            return (List)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<List<ImmutableSegmentLoadInfo>>(){});
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }
}

