/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.io.druid.collections.Releaser;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import sun.misc.Cleaner;

public class ReferenceCountingResourceHolder<T>
implements ResourceHolder<T> {
    private static final Logger log = new Logger(ReferenceCountingResourceHolder.class);
    private static final AtomicLong leakedResources = new AtomicLong();
    private final T object;
    private final Closeable closer;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Cleaner cleaner;

    public static long leakedResources() {
        return leakedResources.get();
    }

    ReferenceCountingResourceHolder(T object, Closeable closer) {
        this.object = object;
        this.closer = closer;
        this.cleaner = Cleaner.create((Object)this, (Runnable)new CloserRunnable(object, closer, this.refCount));
    }

    public static <T extends Closeable> ReferenceCountingResourceHolder<T> fromCloseable(T object) {
        return new ReferenceCountingResourceHolder<T>(object, object);
    }

    @Override
    public T get() {
        if (this.refCount.get() <= 0) {
            throw new ISE("Already closed!", new Object[0]);
        }
        return this.object;
    }

    public Releaser increment() {
        int count;
        do {
            if ((count = this.refCount.get()) > 0) continue;
            throw new ISE("Already closed!", new Object[0]);
        } while (!this.refCount.compareAndSet(count, count + 1));
        return new Releaser(){
            boolean released = false;

            @Override
            public void close() {
                if (!this.released) {
                    ReferenceCountingResourceHolder.this.decrement();
                    this.released = true;
                } else {
                    log.warn(new ISE("Already closed", new Object[0]), "Already closed", new Object[0]);
                }
            }
        };
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.decrement();
        } else {
            log.warn(new ISE("Already closed", new Object[0]), "Already closed", new Object[0]);
        }
    }

    private void decrement() {
        if (this.refCount.decrementAndGet() == 0) {
            try {
                this.closer.close();
            }
            catch (IOException e) {
                throw Throwables.propagate(e);
            }
        }
    }

    private static class CloserRunnable
    implements Runnable {
        private final Object object;
        private final Closeable closer;
        private final AtomicInteger refCount;

        private CloserRunnable(Object object, Closeable closer, AtomicInteger refCount) {
            this.object = object;
            this.closer = closer;
            this.refCount = refCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            int count;
            while ((count = this.refCount.get()) > 0) {
                if (!this.refCount.compareAndSet(count, 0)) continue;
                leakedResources.incrementAndGet();
                this.closer.close();
                try {
                    log.warn("Not closed! Object was[%s]", this.object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
                catch (Exception e) {
                    try {
                        try {
                            log.error(e, "Exception in closer", new Object[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            log.warn("Not closed! Object was[%s]", this.object);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        log.warn("Not closed! Object was[%s]", this.object);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                break;
            }
            return;
        }
    }
}

