/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.common.guava;

import java.io.IOException;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.io.druid.java.util.common.guava.Accumulator;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Yielder;
import org.apache.hive.druid.io.druid.java.util.common.guava.Yielders;
import org.apache.hive.druid.io.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.hive.druid.io.druid.java.util.common.guava.nary.BinaryFn;

public class CombiningSequence<T>
implements Sequence<T> {
    private final Sequence<T> baseSequence;
    private final Ordering<T> ordering;
    private final BinaryFn<T, T, T> mergeFn;

    public static <T> CombiningSequence<T> create(Sequence<T> baseSequence, Ordering<T> ordering, BinaryFn<T, T, T> mergeFn) {
        return new CombiningSequence<T>(baseSequence, ordering, mergeFn);
    }

    private CombiningSequence(Sequence<T> baseSequence, Ordering<T> ordering, BinaryFn<T, T, T> mergeFn) {
        this.baseSequence = baseSequence;
        this.ordering = ordering;
        this.mergeFn = mergeFn;
    }

    @Override
    public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
        CombiningAccumulator<OutType> combiningAccumulator = new CombiningAccumulator<OutType>(initValue, accumulator);
        Object lastValue = this.baseSequence.accumulate(null, combiningAccumulator);
        if (combiningAccumulator.accumulatedSomething()) {
            return (OutType)accumulator.accumulate(((CombiningAccumulator)combiningAccumulator).retVal, lastValue);
        }
        return initValue;
    }

    @Override
    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
        CombiningYieldingAccumulator<OutType, T> combiningAccumulator = new CombiningYieldingAccumulator<OutType, T>(this.ordering, this.mergeFn, accumulator);
        combiningAccumulator.setRetVal(initValue);
        Yielder<Object> baseYielder = this.baseSequence.toYielder(null, combiningAccumulator);
        return this.makeYielder(baseYielder, combiningAccumulator, false);
    }

    private <OutType> Yielder<OutType> makeYielder(final Yielder<T> yielder, final CombiningYieldingAccumulator<OutType, T> combiningAccumulator, boolean finalValue) {
        boolean finalFinalValue;
        Yielder<Object> finalYielder;
        OutType retVal;
        if (!yielder.isDone()) {
            retVal = combiningAccumulator.getRetVal();
            finalYielder = null;
            finalFinalValue = false;
        } else if (!finalValue && combiningAccumulator.accumulatedSomething()) {
            combiningAccumulator.accumulateLastValue();
            retVal = combiningAccumulator.getRetVal();
            finalFinalValue = true;
            if (!combiningAccumulator.yielded()) {
                return Yielders.done(retVal, yielder);
            }
            finalYielder = Yielders.done(null, yielder);
        } else {
            return Yielders.done(combiningAccumulator.getRetVal(), yielder);
        }
        return new Yielder<OutType>(){

            @Override
            public OutType get() {
                return retVal;
            }

            @Override
            public Yielder<OutType> next(OutType initValue) {
                combiningAccumulator.reset();
                return CombiningSequence.this.makeYielder(finalYielder == null ? yielder.next(yielder.get()) : finalYielder, combiningAccumulator, finalFinalValue);
            }

            @Override
            public boolean isDone() {
                return false;
            }

            @Override
            public void close() throws IOException {
                yielder.close();
            }
        };
    }

    private class CombiningAccumulator<OutType>
    implements Accumulator<T, T> {
        private OutType retVal;
        private final Accumulator<OutType, T> accumulator;
        private volatile boolean accumulatedSomething = false;

        CombiningAccumulator(OutType retVal, Accumulator<OutType, T> accumulator) {
            this.retVal = retVal;
            this.accumulator = accumulator;
        }

        boolean accumulatedSomething() {
            return this.accumulatedSomething;
        }

        @Override
        public T accumulate(T prevValue, T t) {
            if (!this.accumulatedSomething) {
                this.accumulatedSomething = true;
            }
            if (prevValue == null) {
                return CombiningSequence.this.mergeFn.apply(t, null);
            }
            if (CombiningSequence.this.ordering.compare(prevValue, t) == 0) {
                return CombiningSequence.this.mergeFn.apply(prevValue, t);
            }
            this.retVal = this.accumulator.accumulate(this.retVal, prevValue);
            return t;
        }
    }

    private static class CombiningYieldingAccumulator<OutType, T>
    extends YieldingAccumulator<T, T> {
        private final Ordering<T> ordering;
        private final BinaryFn<T, T, T> mergeFn;
        private final YieldingAccumulator<OutType, T> accumulator;
        private OutType retVal;
        private T lastMergedVal;
        private boolean accumulatedSomething = false;

        CombiningYieldingAccumulator(Ordering<T> ordering, BinaryFn<T, T, T> mergeFn, YieldingAccumulator<OutType, T> accumulator) {
            this.ordering = ordering;
            this.mergeFn = mergeFn;
            this.accumulator = accumulator;
        }

        public OutType getRetVal() {
            return this.retVal;
        }

        public void setRetVal(OutType retVal) {
            this.retVal = retVal;
        }

        @Override
        public void reset() {
            this.accumulator.reset();
        }

        @Override
        public boolean yielded() {
            return this.accumulator.yielded();
        }

        @Override
        public void yield() {
            this.accumulator.yield();
        }

        @Override
        public T accumulate(T prevValue, T t) {
            if (!this.accumulatedSomething) {
                this.accumulatedSomething = true;
            }
            if (prevValue == null) {
                this.lastMergedVal = this.mergeFn.apply(t, null);
                return this.lastMergedVal;
            }
            if (this.ordering.compare(prevValue, t) == 0) {
                this.lastMergedVal = this.mergeFn.apply(prevValue, t);
                return this.lastMergedVal;
            }
            this.lastMergedVal = t;
            this.retVal = this.accumulator.accumulate(this.retVal, prevValue);
            return t;
        }

        void accumulateLastValue() {
            this.retVal = this.accumulator.accumulate(this.retVal, this.lastMergedVal);
        }

        boolean accumulatedSomething() {
            return this.accumulatedSomething;
        }
    }
}

