/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.data.input.impl.prefetch;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.LineIterator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.data.input.Firehose;
import org.apache.hive.druid.io.druid.data.input.impl.AbstractTextFilesFirehoseFactory;
import org.apache.hive.druid.io.druid.data.input.impl.FileIteratingFirehose;
import org.apache.hive.druid.io.druid.data.input.impl.StringInputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.prefetch.CacheManager;
import org.apache.hive.druid.io.druid.data.input.impl.prefetch.Fetcher;
import org.apache.hive.druid.io.druid.data.input.impl.prefetch.OpenedObject;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;

public abstract class PrefetchableTextFilesFirehoseFactory<T>
extends AbstractTextFilesFirehoseFactory<T> {
    private static final Logger LOG = new Logger(PrefetchableTextFilesFirehoseFactory.class);
    private static final long DEFAULT_MAX_CACHE_CAPACITY_BYTES = 0x40000000L;
    private static final long DEFAULT_MAX_FETCH_CAPACITY_BYTES = 0x40000000L;
    private static final long DEFAULT_FETCH_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(60L);
    private static final int DEFAULT_MAX_FETCH_RETRY = 3;
    private final CacheManager<T> cacheManager;
    private final long maxFetchCapacityBytes;
    private final long prefetchTriggerBytes;
    private final long fetchTimeout;
    private final int maxFetchRetry;
    private List<T> objects;

    public PrefetchableTextFilesFirehoseFactory(Long maxCacheCapacityBytes, Long maxFetchCapacityBytes, Long prefetchTriggerBytes, Long fetchTimeout, Integer maxFetchRetry) {
        this.cacheManager = new CacheManager(maxCacheCapacityBytes == null ? 0x40000000L : maxCacheCapacityBytes);
        this.maxFetchCapacityBytes = maxFetchCapacityBytes == null ? 0x40000000L : maxFetchCapacityBytes;
        this.prefetchTriggerBytes = prefetchTriggerBytes == null ? this.maxFetchCapacityBytes / 2L : prefetchTriggerBytes;
        this.fetchTimeout = fetchTimeout == null ? DEFAULT_FETCH_TIMEOUT_MS : fetchTimeout;
        this.maxFetchRetry = maxFetchRetry == null ? 3 : maxFetchRetry;
    }

    @JsonProperty
    public long getMaxCacheCapacityBytes() {
        return this.cacheManager.getMaxCacheCapacityBytes();
    }

    @JsonProperty
    public long getMaxFetchCapacityBytes() {
        return this.maxFetchCapacityBytes;
    }

    @JsonProperty
    public long getPrefetchTriggerBytes() {
        return this.prefetchTriggerBytes;
    }

    @JsonProperty
    public long getFetchTimeout() {
        return this.fetchTimeout;
    }

    @JsonProperty
    public int getMaxFetchRetry() {
        return this.maxFetchRetry;
    }

    @VisibleForTesting
    CacheManager<T> getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public Firehose connect(StringInputRowParser firehoseParser, File temporaryDirectory) throws IOException {
        if (!this.cacheManager.isEnabled() && this.maxFetchCapacityBytes == 0L) {
            return super.connect(firehoseParser, temporaryDirectory);
        }
        if (this.objects == null) {
            this.objects = ImmutableList.copyOf(Preconditions.checkNotNull(this.initObjects(), "objects"));
        }
        Preconditions.checkState(temporaryDirectory.exists(), "temporaryDirectory[%s] does not exist", temporaryDirectory);
        Preconditions.checkState(temporaryDirectory.isDirectory(), "temporaryDirectory[%s] is not a directory", temporaryDirectory);
        LOG.info("Create a new firehose for [%d] objects", this.objects.size());
        ExecutorService fetchExecutor = Execs.singleThreaded("firehose_fetch_%d");
        final Fetcher<Object> fetcher = new Fetcher<Object>(this.cacheManager, this.objects, fetchExecutor, temporaryDirectory, this.maxFetchCapacityBytes, this.prefetchTriggerBytes, this.fetchTimeout, this.maxFetchRetry, this::openObjectStream);
        return new FileIteratingFirehose(new Iterator<LineIterator>(){

            @Override
            public boolean hasNext() {
                return fetcher.hasNext();
            }

            @Override
            public LineIterator next() {
                InputStream stream;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object openedObject = fetcher.next();
                try {
                    stream = PrefetchableTextFilesFirehoseFactory.this.wrapObjectStream(((OpenedObject)openedObject).getObject(), ((OpenedObject)openedObject).getObjectStream());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return new ResourceCloseableLineIterator(new InputStreamReader(stream, StandardCharsets.UTF_8), ((OpenedObject)openedObject).getResourceCloser());
            }
        }, firehoseParser, () -> {
            fetchExecutor.shutdownNow();
            try {
                Preconditions.checkState(fetchExecutor.awaitTermination(this.fetchTimeout, TimeUnit.MILLISECONDS));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ISE("Failed to shutdown fetch executor during close", new Object[0]);
            }
        });
    }

    static class ResourceCloseableLineIterator
    extends LineIterator {
        private final Closeable resourceCloser;

        ResourceCloseableLineIterator(Reader reader, Closeable resourceCloser) throws IllegalArgumentException {
            super(reader);
            this.resourceCloser = resourceCloser;
        }

        public void close() {
            super.close();
            try {
                this.resourceCloser.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

