/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common.guava;

import java.util.Iterator;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Predicates;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.io.druid.java.util.common.guava.DroppingIterator;
import org.apache.hive.druid.io.druid.java.util.common.guava.nary.BinaryFn;
import org.apache.hive.druid.io.druid.java.util.common.guava.nary.BinaryTransformIterator;
import org.apache.hive.druid.io.druid.java.util.common.guava.nary.TrinaryFn;
import org.apache.hive.druid.io.druid.java.util.common.guava.nary.TrinaryTransformIterator;

public class FunctionalIterator<T>
implements Iterator<T> {
    private final Iterator<T> delegate;

    public static <T> FunctionalIterator<T> create(Iterator<T> delegate) {
        return new FunctionalIterator<T>(delegate);
    }

    public static <T> FunctionalIterator<T> fromConcatenation(Iterator<T> ... toConcat) {
        return new FunctionalIterator<T>(Iterators.concat(toConcat));
    }

    public static <T> FunctionalIterator<T> fromConcatenation(Iterator<Iterator<T>> toConcat) {
        return new FunctionalIterator<T>(Iterators.concat(toConcat));
    }

    public FunctionalIterator(Iterator<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public T next() {
        return this.delegate.next();
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    public <RetType> FunctionalIterator<RetType> transform(Function<T, RetType> fn) {
        return new FunctionalIterator<RetType>(Iterators.transform(this.delegate, fn));
    }

    public <RetType> FunctionalIterator<RetType> transformCat(Function<T, Iterator<RetType>> fn) {
        return new FunctionalIterator<RetType>(Iterators.concat(Iterators.transform(this.delegate, fn)));
    }

    public <RetType> FunctionalIterator<RetType> keep(Function<T, RetType> fn) {
        return new FunctionalIterator<RetType>(Iterators.filter(Iterators.transform(this.delegate, fn), Predicates.notNull()));
    }

    public FunctionalIterator<T> filter(Predicate<T> pred) {
        return new FunctionalIterator<T>(Iterators.filter(this.delegate, pred));
    }

    public FunctionalIterator<T> drop(int numToDrop) {
        return new FunctionalIterator<T>(new DroppingIterator<T>(this.delegate, numToDrop));
    }

    public FunctionalIterator<T> limit(int limit) {
        return new FunctionalIterator<T>(Iterators.limit(this.delegate, limit));
    }

    public FunctionalIterator<T> concat(Iterator<T> ... toConcat) {
        if (toConcat.length == 1) {
            return new FunctionalIterator<T>(Iterators.concat(this.delegate, toConcat[0]));
        }
        return new FunctionalIterator<T>(Iterators.concat(this.delegate, Iterators.concat(toConcat)));
    }

    public FunctionalIterator<T> concat(Iterator<Iterator<T>> toConcat) {
        return new FunctionalIterator<T>(Iterators.concat(this.delegate, Iterators.concat(toConcat)));
    }

    public <InType, RetType> FunctionalIterator<RetType> binaryTransform(Iterator<InType> otherIterator, BinaryFn<T, InType, RetType> binaryFn) {
        return new FunctionalIterator<T>(BinaryTransformIterator.create(this.delegate, otherIterator, binaryFn));
    }

    public <InType1, InType2, RetType> FunctionalIterator<RetType> trinaryTransform(Iterator<InType1> iterator1, Iterator<InType2> iterator2, TrinaryFn<T, InType1, InType2, RetType> trinaryFn) {
        return new FunctionalIterator<T>(TrinaryTransformIterator.create(this.delegate, iterator1, iterator2, trinaryFn));
    }
}

