/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common.parsers;

import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.io.druid.java.util.common.parsers.ParseException;
import org.apache.hive.druid.io.druid.java.util.common.parsers.Parser;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptParser
implements Parser<String, Object> {
    private final Function<Object, Object> fn;

    private static Function<Object, Object> compile(String function) {
        final ContextFactory contextFactory = ContextFactory.getGlobal();
        Context context = contextFactory.enterContext();
        context.setOptimizationLevel(9);
        final ScriptableObject scope = context.initStandardObjects();
        final org.mozilla.javascript.Function fn = context.compileFunction((Scriptable)scope, function, "fn", 1, null);
        Context.exit();
        return new Function<Object, Object>(){

            @Override
            public Object apply(Object input) {
                Object res;
                Context cx = Context.getCurrentContext();
                if (cx == null) {
                    cx = contextFactory.enterContext();
                }
                return (res = fn.call(cx, (Scriptable)scope, (Scriptable)scope, new Object[]{input})) != null ? Context.toObject((Object)res, (Scriptable)scope) : null;
            }
        };
    }

    public JavaScriptParser(String function) {
        this.fn = JavaScriptParser.compile(function);
    }

    public Function<Object, Object> getFn() {
        return this.fn;
    }

    @Override
    public Map<String, Object> parseToMap(String input) {
        try {
            Object compiled = this.fn.apply(input);
            if (!(compiled instanceof Map)) {
                throw new ParseException("JavaScript parsed value must be in {key: value} format!", new Object[0]);
            }
            return (Map)compiled;
        }
        catch (Exception e) {
            throw new ParseException(e, "Unable to parse row [%s]", input);
        }
    }

    @Override
    public void setFieldNames(Iterable<String> fieldNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getFieldNames() {
        throw new UnsupportedOperationException();
    }
}

