/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.java.util.common.guava.LazySequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.query.AbstractPrioritizedCallable;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryContexts;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryWatcher;

public class AsyncQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;
    private final ListeningExecutorService executor;
    private final QueryWatcher queryWatcher;

    public AsyncQueryRunner(QueryRunner<T> baseRunner, ExecutorService executor, QueryWatcher queryWatcher) {
        this.baseRunner = baseRunner;
        this.executor = MoreExecutors.listeningDecorator(executor);
        this.queryWatcher = queryWatcher;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, final Map<String, Object> responseContext) {
        final Query<T> query = queryPlus.getQuery();
        int priority = QueryContexts.getPriority(query);
        final QueryPlus<T> threadSafeQueryPlus = queryPlus.withoutThreadUnsafeState();
        final ListenableFuture future = this.executor.submit(new AbstractPrioritizedCallable<Sequence<T>>(priority){

            @Override
            public Sequence<T> call() throws Exception {
                return AsyncQueryRunner.this.baseRunner.run(threadSafeQueryPlus, responseContext);
            }
        });
        this.queryWatcher.registerQuery(query, future);
        return new LazySequence(new Supplier<Sequence<T>>(){

            @Override
            public Sequence<T> get() {
                try {
                    if (QueryContexts.hasTimeout(query)) {
                        return (Sequence)future.get(QueryContexts.getTimeout(query), TimeUnit.MILLISECONDS);
                    }
                    return (Sequence)future.get();
                }
                catch (InterruptedException | ExecutionException | TimeoutException ex) {
                    throw Throwables.propagate(ex);
                }
            }
        });
    }
}

