/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprEval;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.query.expression.ExprUtils;

public class TimestampFloorExprMacro
implements ExprMacroTable.ExprMacro {
    @Override
    public String name() {
        return "timestamp_floor";
    }

    @Override
    public Expr apply(List<Expr> args) {
        if (args.size() < 2 || args.size() > 4) {
            throw new IAE("Function[%s] must have 2 to 4 arguments", this.name());
        }
        if (args.stream().skip(1L).allMatch(Expr::isLiteral)) {
            return new TimestampFloorExpr(args);
        }
        return new TimestampFloorDynamicExpr(args);
    }

    private static PeriodGranularity computeGranularity(List<Expr> args, Expr.ObjectBinding bindings) {
        return ExprUtils.toPeriodGranularity(args.get(1), args.size() > 2 ? args.get(2) : null, args.size() > 3 ? args.get(3) : null, bindings);
    }

    public static class TimestampFloorDynamicExpr
    implements Expr {
        private final List<Expr> args;

        public TimestampFloorDynamicExpr(List<Expr> args) {
            this.args = args;
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            PeriodGranularity granularity = TimestampFloorExprMacro.computeGranularity(this.args, bindings);
            return ExprEval.of(granularity.bucketStart(DateTimes.utc(this.args.get(0).eval(bindings).asLong())).getMillis());
        }

        @Override
        public void visit(Expr.Visitor visitor) {
            for (Expr arg : this.args) {
                arg.visit(visitor);
            }
            visitor.visit(this);
        }
    }

    public static class TimestampFloorExpr
    implements Expr {
        private final Expr arg;
        private final PeriodGranularity granularity;

        public TimestampFloorExpr(List<Expr> args) {
            this.arg = args.get(0);
            this.granularity = TimestampFloorExprMacro.computeGranularity(args, ExprUtils.nilBindings());
        }

        public Expr getArg() {
            return this.arg;
        }

        public PeriodGranularity getGranularity() {
            return this.granularity;
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            return ExprEval.of(this.granularity.bucketStart(DateTimes.utc(this.arg.eval(bindings).asLong())).getMillis());
        }

        @Override
        public void visit(Expr.Visitor visitor) {
            this.arg.visit(visitor);
            visitor.visit(this);
        }
    }
}

