/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.topn.types;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.topn.BaseTopNAlgorithm;
import org.apache.hive.druid.io.druid.query.topn.TopNParams;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNResultBuilder;
import org.apache.hive.druid.io.druid.query.topn.types.TopNColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.BaseFloatColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.BaseLongColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.Capabilities;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.column.ValueType;

public abstract class NumericTopNColumnSelectorStrategy<ValueSelectorType, DimExtractionAggregateStoreType extends Map<?, Aggregator[]>>
implements TopNColumnSelectorStrategy<ValueSelectorType, DimExtractionAggregateStoreType> {
    @Override
    public int getCardinality(ValueSelectorType selector) {
        return -1;
    }

    @Override
    public Aggregator[][] getDimExtractionRowSelector(TopNQuery query, TopNParams params, Capabilities capabilities) {
        return null;
    }

    static long floatDimExtractionScanAndAggregate(TopNQuery query, BaseFloatColumnValueSelector selector, Cursor cursor, Int2ObjectMap<Aggregator[]> aggregatesStore) {
        long processedRows = 0L;
        while (!cursor.isDone()) {
            int key = Float.floatToIntBits(selector.getFloat());
            Aggregator[] theAggregators = (Aggregator[])aggregatesStore.get(key);
            if (theAggregators == null) {
                theAggregators = BaseTopNAlgorithm.makeAggregators(cursor, query.getAggregatorSpecs());
                aggregatesStore.put(key, theAggregators);
            }
            for (Aggregator aggregator : theAggregators) {
                aggregator.aggregate();
            }
            cursor.advance();
            ++processedRows;
        }
        return processedRows;
    }

    static long doubleDimExtractionScanAndAggregate(TopNQuery query, BaseDoubleColumnValueSelector selector, Cursor cursor, Long2ObjectMap<Aggregator[]> aggregatesStore) {
        long processedRows = 0L;
        while (!cursor.isDone()) {
            long key = Double.doubleToLongBits(selector.getDouble());
            Aggregator[] theAggregators = (Aggregator[])aggregatesStore.get(key);
            if (theAggregators == null) {
                theAggregators = BaseTopNAlgorithm.makeAggregators(cursor, query.getAggregatorSpecs());
                aggregatesStore.put(key, theAggregators);
            }
            for (Aggregator aggregator : theAggregators) {
                aggregator.aggregate();
            }
            cursor.advance();
            ++processedRows;
        }
        return processedRows;
    }

    static long longDimExtractionScanAndAggregate(TopNQuery query, BaseLongColumnValueSelector selector, Cursor cursor, Long2ObjectMap<Aggregator[]> aggregatesStore) {
        long processedRows = 0L;
        while (!cursor.isDone()) {
            long key = selector.getLong();
            Aggregator[] theAggregators = (Aggregator[])aggregatesStore.get(key);
            if (theAggregators == null) {
                theAggregators = BaseTopNAlgorithm.makeAggregators(cursor, query.getAggregatorSpecs());
                aggregatesStore.put(key, theAggregators);
            }
            for (Aggregator aggregator : theAggregators) {
                aggregator.aggregate();
            }
            cursor.advance();
            ++processedRows;
        }
        return processedRows;
    }

    @Override
    public void updateDimExtractionResults(DimExtractionAggregateStoreType aggregatesStore, Function<Object, Object> valueTransformer, TopNResultBuilder resultBuilder) {
        for (Map.Entry entry : aggregatesStore.entrySet()) {
            Aggregator[] aggs = (Aggregator[])entry.getValue();
            if (aggs == null) continue;
            Object[] vals = new Object[aggs.length];
            for (int i = 0; i < aggs.length; ++i) {
                vals[i] = aggs[i].get();
            }
            Comparable key = this.convertAggregatorStoreKeyToColumnValue(entry.getKey());
            if (valueTransformer != null) {
                key = (Comparable)valueTransformer.apply(key);
            }
            resultBuilder.addEntry(key, key, vals);
        }
    }

    abstract Comparable convertAggregatorStoreKeyToColumnValue(Object var1);

    static class OfDouble
    extends NumericTopNColumnSelectorStrategy<BaseDoubleColumnValueSelector, Long2ObjectMap<Aggregator[]>> {
        OfDouble() {
        }

        @Override
        public ValueType getValueType() {
            return ValueType.DOUBLE;
        }

        @Override
        public Long2ObjectMap<Aggregator[]> makeDimExtractionAggregateStore() {
            return new Long2ObjectOpenHashMap<Aggregator[]>();
        }

        @Override
        Comparable convertAggregatorStoreKeyToColumnValue(Object aggregatorStoreKey) {
            return Double.valueOf(Double.longBitsToDouble((Long)aggregatorStoreKey));
        }

        @Override
        public long dimExtractionScanAndAggregate(TopNQuery query, BaseDoubleColumnValueSelector selector, Cursor cursor, Aggregator[][] rowSelector, Long2ObjectMap<Aggregator[]> aggregatesStore) {
            return OfDouble.doubleDimExtractionScanAndAggregate(query, selector, cursor, aggregatesStore);
        }
    }

    static class OfLong
    extends NumericTopNColumnSelectorStrategy<BaseLongColumnValueSelector, Long2ObjectMap<Aggregator[]>> {
        OfLong() {
        }

        @Override
        public ValueType getValueType() {
            return ValueType.LONG;
        }

        @Override
        public Long2ObjectMap<Aggregator[]> makeDimExtractionAggregateStore() {
            return new Long2ObjectOpenHashMap<Aggregator[]>();
        }

        @Override
        Comparable convertAggregatorStoreKeyToColumnValue(Object aggregatorStoreKey) {
            return (Long)aggregatorStoreKey;
        }

        @Override
        public long dimExtractionScanAndAggregate(TopNQuery query, BaseLongColumnValueSelector selector, Cursor cursor, Aggregator[][] rowSelector, Long2ObjectMap<Aggregator[]> aggregatesStore) {
            return OfLong.longDimExtractionScanAndAggregate(query, selector, cursor, aggregatesStore);
        }
    }

    static class OfFloat
    extends NumericTopNColumnSelectorStrategy<BaseFloatColumnValueSelector, Int2ObjectMap<Aggregator[]>> {
        OfFloat() {
        }

        @Override
        public ValueType getValueType() {
            return ValueType.FLOAT;
        }

        @Override
        public Int2ObjectMap<Aggregator[]> makeDimExtractionAggregateStore() {
            return new Int2ObjectOpenHashMap<Aggregator[]>();
        }

        @Override
        Comparable convertAggregatorStoreKeyToColumnValue(Object aggregatorStoreKey) {
            return Float.valueOf(Float.intBitsToFloat((Integer)aggregatorStoreKey));
        }

        @Override
        public long dimExtractionScanAndAggregate(TopNQuery query, BaseFloatColumnValueSelector selector, Cursor cursor, Aggregator[][] rowSelector, Int2ObjectMap<Aggregator[]> aggregatesStore) {
            return OfFloat.floatDimExtractionScanAndAggregate(query, selector, cursor, aggregatesStore);
        }
    }
}

