/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import it.unimi.dsi.fastutil.ints.AbstractIntList;
import it.unimi.dsi.fastutil.ints.IntList;
import org.apache.hive.druid.com.google.common.base.Preconditions;

public class IntListUtils {
    private IntListUtils() {
    }

    public static IntList fromTo(int from, int to) {
        Preconditions.checkArgument(from <= to);
        return new RangeIntList(from, to);
    }

    private static final class RangeIntList
    extends AbstractIntList {
        private final int start;
        private final int size;

        RangeIntList(int start, int end) {
            this.start = start;
            this.size = end - start;
        }

        @Override
        public int getInt(int index) {
            Preconditions.checkElementIndex(index, this.size);
            return this.start + index;
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

