/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.io.Closeables;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.common.utils.ByteUtils;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.io.druid.java.util.common.io.Closer;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.data.ColumnarInts;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.io.druid.segment.data.DecompressingByteBufferObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.data.VSizeColumnarInts;
import org.apache.hive.druid.io.druid.segment.data.WritableSupplier;
import org.apache.hive.druid.io.druid.segment.serde.MetaSerdeHelper;

public class CompressedVSizeColumnarIntsSupplier
implements WritableSupplier<ColumnarInts> {
    public static final byte VERSION = 2;
    private static final MetaSerdeHelper<CompressedVSizeColumnarIntsSupplier> metaSerdeHelper = MetaSerdeHelper.firstWriteByte(x -> 2).writeByte(x -> ByteUtils.checkedCast(x.numBytes)).writeInt(x -> x.totalSize).writeInt(x -> x.sizePer).writeByte(x -> x.compression.getId());
    private final int totalSize;
    private final int sizePer;
    private final int numBytes;
    private final int bigEndianShift;
    private final int littleEndianMask;
    private final GenericIndexed<ResourceHolder<ByteBuffer>> baseBuffers;
    private final CompressionStrategy compression;

    private CompressedVSizeColumnarIntsSupplier(int totalSize, int sizePer, int numBytes, GenericIndexed<ResourceHolder<ByteBuffer>> baseBuffers, CompressionStrategy compression) {
        Preconditions.checkArgument(sizePer == 1 << Integer.numberOfTrailingZeros(sizePer), "Number of entries per chunk must be a power of 2");
        this.totalSize = totalSize;
        this.sizePer = sizePer;
        this.baseBuffers = baseBuffers;
        this.compression = compression;
        this.numBytes = numBytes;
        this.bigEndianShift = 32 - (numBytes << 3);
        this.littleEndianMask = (int)((1L << (numBytes << 3)) - 1L);
    }

    public static int maxIntsInBufferForBytes(int numBytes) {
        int maxSizePer = (65536 - CompressedVSizeColumnarIntsSupplier.bufferPadding(numBytes)) / numBytes;
        return Integer.highestOneBit(maxSizePer);
    }

    static int bufferPadding(int numBytes) {
        switch (numBytes) {
            case 1: 
            case 2: {
                return 0;
            }
        }
        return 4 - numBytes;
    }

    public static int maxIntsInBufferForValue(int maxValue) {
        return CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForBytes(VSizeColumnarInts.getNumBytesForMax(maxValue));
    }

    @Override
    public ColumnarInts get() {
        if (this.numBytes == 4) {
            return new CompressedFullSizeColumnarInts();
        }
        if (this.numBytes == 2) {
            return new CompressedShortSizeColumnarInts();
        }
        if (this.numBytes == 1) {
            return new CompressedByteSizeColumnarInts();
        }
        return new CompressedVSizeColumnarInts();
    }

    @Override
    public long getSerializedSize() throws IOException {
        return (long)metaSerdeHelper.size(this) + this.baseBuffers.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        metaSerdeHelper.writeTo(channel, this);
        this.baseBuffers.writeTo(channel, smoosher);
    }

    @VisibleForTesting
    GenericIndexed<ResourceHolder<ByteBuffer>> getBaseBuffers() {
        return this.baseBuffers;
    }

    public static CompressedVSizeColumnarIntsSupplier fromByteBuffer(ByteBuffer buffer, ByteOrder order) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 2) {
            byte numBytes = buffer.get();
            int totalSize = buffer.getInt();
            int sizePer = buffer.getInt();
            CompressionStrategy compression = CompressionStrategy.forId(buffer.get());
            return new CompressedVSizeColumnarIntsSupplier(totalSize, sizePer, numBytes, GenericIndexed.read(buffer, new DecompressingByteBufferObjectStrategy(order, compression)), compression);
        }
        throw new IAE("Unknown version[%s]", versionFromBuffer);
    }

    @VisibleForTesting
    public static CompressedVSizeColumnarIntsSupplier fromList(final IntList list, int maxValue, final int chunkFactor, final ByteOrder byteOrder, final CompressionStrategy compression, final Closer closer) {
        final byte numBytes = VSizeColumnarInts.getNumBytesForMax(maxValue);
        final int chunkBytes = chunkFactor * numBytes;
        Preconditions.checkArgument(chunkFactor <= CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForBytes(numBytes), "Chunks must be <= 64k bytes. chunkFactor was[%s]", chunkFactor);
        return new CompressedVSizeColumnarIntsSupplier(list.size(), chunkFactor, numBytes, GenericIndexed.ofCompressedByteBuffers(new Iterable<ByteBuffer>(){

            @Override
            public Iterator<ByteBuffer> iterator() {
                return new Iterator<ByteBuffer>(){
                    int position = 0;
                    private final ByteBuffer retVal;
                    private final boolean isBigEndian;
                    private final ByteBuffer helperBuf;
                    {
                        this.retVal = compression.getCompressor().allocateInBuffer(chunkBytes, closer).order(byteOrder);
                        this.isBigEndian = byteOrder.equals(ByteOrder.BIG_ENDIAN);
                        this.helperBuf = ByteBuffer.allocate(4).order(byteOrder);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.position < list.size();
                    }

                    @Override
                    public ByteBuffer next() {
                        this.retVal.clear();
                        int elementCount = Math.min(list.size() - this.position, chunkFactor);
                        this.retVal.limit(numBytes * elementCount);
                        int limit = this.position + elementCount;
                        while (this.position < limit) {
                            this.writeIntToRetVal(list.getInt(this.position));
                            ++this.position;
                        }
                        this.retVal.rewind();
                        return this.retVal;
                    }

                    private void writeIntToRetVal(int value) {
                        this.helperBuf.putInt(0, value);
                        if (this.isBigEndian) {
                            this.retVal.put(this.helperBuf.array(), 4 - numBytes, numBytes);
                        } else {
                            this.retVal.put(this.helperBuf.array(), 0, numBytes);
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, compression, chunkBytes, byteOrder, closer), compression);
    }

    private class CompressedVSizeColumnarInts
    implements ColumnarInts {
        final Indexed<ResourceHolder<ByteBuffer>> singleThreadedBuffers;
        final int div;
        final int rem;
        int currIndex;
        ResourceHolder<ByteBuffer> holder;
        ByteBuffer buffer;
        boolean bigEndian;

        private CompressedVSizeColumnarInts() {
            this.singleThreadedBuffers = CompressedVSizeColumnarIntsSupplier.this.baseBuffers.singleThreaded();
            this.div = Integer.numberOfTrailingZeros(CompressedVSizeColumnarIntsSupplier.this.sizePer);
            this.rem = CompressedVSizeColumnarIntsSupplier.this.sizePer - 1;
            this.currIndex = -1;
        }

        @Override
        public int size() {
            return CompressedVSizeColumnarIntsSupplier.this.totalSize;
        }

        @Override
        public int get(int index) {
            int bufferNum = index >> this.div;
            if (bufferNum != this.currIndex) {
                this.loadBuffer(bufferNum);
            }
            return this._get(index & this.rem);
        }

        protected int _get(int index) {
            int pos = this.buffer.position() + index * CompressedVSizeColumnarIntsSupplier.this.numBytes;
            return this.bigEndian ? this.buffer.getInt(pos) >>> CompressedVSizeColumnarIntsSupplier.this.bigEndianShift : this.buffer.getInt(pos) & CompressedVSizeColumnarIntsSupplier.this.littleEndianMask;
        }

        protected void loadBuffer(int bufferNum) {
            CloseQuietly.close(this.holder);
            this.holder = this.singleThreadedBuffers.get(bufferNum);
            this.buffer = this.holder.get();
            this.currIndex = bufferNum;
            this.bigEndian = this.buffer.order().equals(ByteOrder.BIG_ENDIAN);
        }

        public String toString() {
            return "CompressedVSizedIntsIndexedSupplier{currIndex=" + this.currIndex + ", sizePer=" + CompressedVSizeColumnarIntsSupplier.this.sizePer + ", numChunks=" + this.singleThreadedBuffers.size() + ", totalSize=" + CompressedVSizeColumnarIntsSupplier.this.totalSize + '}';
        }

        @Override
        public void close() throws IOException {
            Closeables.close(this.holder, false);
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("singleThreadedBuffers", this.singleThreadedBuffers);
        }
    }

    private class CompressedByteSizeColumnarInts
    extends CompressedVSizeColumnarInts {
        private CompressedByteSizeColumnarInts() {
        }

        @Override
        protected int _get(int index) {
            return this.buffer.get(this.buffer.position() + index) & 0xFF;
        }
    }

    private class CompressedShortSizeColumnarInts
    extends CompressedVSizeColumnarInts {
        ShortBuffer shortBuffer;

        private CompressedShortSizeColumnarInts() {
        }

        @Override
        protected void loadBuffer(int bufferNum) {
            super.loadBuffer(bufferNum);
            this.shortBuffer = this.buffer.asShortBuffer();
        }

        @Override
        protected int _get(int index) {
            return this.shortBuffer.get(this.shortBuffer.position() + index) & 0xFFFF;
        }
    }

    private class CompressedFullSizeColumnarInts
    extends CompressedVSizeColumnarInts {
        IntBuffer intBuffer;

        private CompressedFullSizeColumnarInts() {
        }

        @Override
        protected void loadBuffer(int bufferNum) {
            super.loadBuffer(bufferNum);
            this.intBuffer = this.buffer.asIntBuffer();
        }

        @Override
        protected int _get(int index) {
            return this.intBuffer.get(this.intBuffer.position() + index);
        }
    }
}

