/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator.rules;

import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.io.druid.server.coordinator.rules.BroadcastDistributionRule;
import org.apache.hive.druid.io.druid.server.coordinator.rules.Rules;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class IntervalBroadcastDistributionRule
extends BroadcastDistributionRule {
    static final String TYPE = "broadcastByInterval";
    private final Interval interval;
    private final List<String> colocatedDataSources;

    @JsonCreator
    public IntervalBroadcastDistributionRule(@JsonProperty(value="interval") Interval interval, @JsonProperty(value="colocatedDataSources") List<String> colocatedDataSources) {
        this.interval = interval;
        this.colocatedDataSources = colocatedDataSources;
    }

    @Override
    @JsonProperty
    public String getType() {
        return TYPE;
    }

    @Override
    @JsonProperty
    public List<String> getColocatedDataSources() {
        return this.colocatedDataSources;
    }

    @Override
    public boolean appliesTo(DataSegment segment, DateTime referenceTimestamp) {
        return this.appliesTo(segment.getInterval(), referenceTimestamp);
    }

    @Override
    public boolean appliesTo(Interval interval, DateTime referenceTimestamp) {
        return Rules.eligibleForLoad(this.interval, interval);
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        IntervalBroadcastDistributionRule that = (IntervalBroadcastDistributionRule)o;
        if (!Objects.equals(this.interval, that.interval)) {
            return false;
        }
        return Objects.equals(this.colocatedDataSources, that.colocatedDataSources);
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.interval, this.colocatedDataSources);
    }
}

