/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.initialization;

import java.util.Objects;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.Period;

public class ServerConfig {
    @JsonProperty
    @Min(value=1L)
    private int numThreads = Math.max(10, Runtime.getRuntime().availableProcessors() * 17 / 16 + 2) + 30;
    @JsonProperty
    @Min(value=1L)
    private int queueSize = Integer.MAX_VALUE;
    @JsonProperty
    private boolean enableRequestLimit = false;
    @JsonProperty
    @NotNull
    private Period maxIdleTime = new Period((Object)"PT5m");
    @JsonProperty
    @Min(value=0L)
    private long defaultQueryTimeout = 300000L;
    @JsonProperty
    @Min(value=1L)
    private long maxScatterGatherBytes = Long.MAX_VALUE;
    @JsonProperty
    @Min(value=1L)
    private long maxQueryTimeout = Long.MAX_VALUE;
    @JsonProperty
    private int maxRequestHeaderSize = 8192;

    public int getNumThreads() {
        return this.numThreads;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public boolean isEnableRequestLimit() {
        return this.enableRequestLimit;
    }

    public Period getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public long getDefaultQueryTimeout() {
        return this.defaultQueryTimeout;
    }

    public long getMaxScatterGatherBytes() {
        return this.maxScatterGatherBytes;
    }

    public long getMaxQueryTimeout() {
        return this.maxQueryTimeout;
    }

    public int getMaxRequestHeaderSize() {
        return this.maxRequestHeaderSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfig that = (ServerConfig)o;
        return this.numThreads == that.numThreads && this.queueSize == that.queueSize && this.enableRequestLimit == that.enableRequestLimit && this.defaultQueryTimeout == that.defaultQueryTimeout && this.maxScatterGatherBytes == that.maxScatterGatherBytes && Objects.equals(this.maxIdleTime, that.maxIdleTime) && this.maxQueryTimeout == that.maxQueryTimeout;
    }

    public int hashCode() {
        return Objects.hash(this.numThreads, this.queueSize, this.enableRequestLimit, this.maxIdleTime, this.defaultQueryTimeout, this.maxScatterGatherBytes, this.maxQueryTimeout);
    }
}

