/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.storage.hdfs;

import com.google.inject.Inject;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hive.druid.io.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.segment.loading.DataSegmentKiller;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.io.druid.storage.hdfs.HdfsDataSegmentPusherConfig;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class HdfsDataSegmentKiller
implements DataSegmentKiller {
    private static final EmittingLogger log = new EmittingLogger(HdfsDataSegmentKiller.class);
    private static final String PATH_KEY = "path";
    private final Configuration config;
    private final Path storageDirectory;

    @Inject
    public HdfsDataSegmentKiller(Configuration config, HdfsDataSegmentPusherConfig pusherConfig) {
        this.config = config;
        this.storageDirectory = new Path(pusherConfig.getStorageDirectory());
    }

    private static Path getPath(DataSegment segment) {
        return new Path(String.valueOf(segment.getLoadSpec().get(PATH_KEY)));
    }

    @Override
    public void kill(DataSegment segment) throws SegmentLoadingException {
        Path segmentPath = HdfsDataSegmentKiller.getPath(segment);
        log.info("killing segment[%s] mapped to path[%s]", segment.getIdentifier(), segmentPath);
        try {
            String segmentLocation = segmentPath.getName();
            FileSystem fs = segmentPath.getFileSystem(this.config);
            if (!segmentLocation.endsWith(".zip")) {
                throw new SegmentLoadingException("Unknown file type[%s]", segmentPath);
            }
            if (!fs.exists(segmentPath)) {
                log.warn("Segment Path [%s] does not exist. It appears to have been deleted already.", segmentPath);
                return;
            }
            String[] zipParts = segmentLocation.split("_");
            if (zipParts.length == 2 && zipParts[1].equals("index.zip") && StringUtils.isNumeric((String)zipParts[0])) {
                if (!fs.delete(segmentPath, false)) {
                    throw new SegmentLoadingException("Unable to kill segment, failed to delete [%s]", segmentPath.toString());
                }
                Path descriptorPath = new Path(segmentPath.getParent(), org.apache.hive.druid.io.druid.java.util.common.StringUtils.format("%s_descriptor.json", zipParts[0]));
                if (!fs.delete(descriptorPath, false)) {
                    throw new SegmentLoadingException("Unable to kill segment, failed to delete [%s]", descriptorPath.toString());
                }
                this.mayBeDeleteParentsUpto(fs, segmentPath, 2);
            } else {
                if (!fs.delete(segmentPath, false)) {
                    throw new SegmentLoadingException("Unable to kill segment, failed to delete [%s]", segmentPath.toString());
                }
                Path descriptorPath = new Path(segmentPath.getParent(), "descriptor.json");
                if (!fs.delete(descriptorPath, false)) {
                    throw new SegmentLoadingException("Unable to kill segment, failed to delete [%s]", descriptorPath.toString());
                }
                this.mayBeDeleteParentsUpto(fs, segmentPath, 3);
            }
        }
        catch (IOException e) {
            throw new SegmentLoadingException(e, "Unable to kill segment", new Object[0]);
        }
    }

    @Override
    public void killAll() throws IOException {
        log.info("Deleting all segment files from hdfs dir [%s].", this.storageDirectory.toUri().toString());
        FileSystem fs = this.storageDirectory.getFileSystem(this.config);
        fs.delete(this.storageDirectory, true);
    }

    private void mayBeDeleteParentsUpto(FileSystem fs, Path segmentPath, int maxDepthTobeDeleted) {
        Path path = segmentPath;
        try {
            for (int i = 1; i <= maxDepthTobeDeleted && fs.listStatus(path = path.getParent()).length == 0 && fs.delete(path, false); ++i) {
            }
        }
        catch (Exception e) {
            log.makeAlert(e, "uncaught exception during segment killer", new Object[0]).emit();
        }
    }
}

