/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.util;

import java.util.TimeZone;

public class DateTimeStringUtils {
    private DateTimeStringUtils() {
    }

    static String pad(int length, long v) {
        StringBuilder s = new StringBuilder(Long.toString(v));
        while (s.length() < length) {
            s.insert(0, "0");
        }
        return s.toString();
    }

    static StringBuilder hms(StringBuilder b, int h, int m, int s) {
        DateTimeStringUtils.int2(b, h);
        b.append(':');
        DateTimeStringUtils.int2(b, m);
        b.append(':');
        DateTimeStringUtils.int2(b, s);
        return b;
    }

    static StringBuilder ymdhms(StringBuilder b, int year, int month, int day, int h, int m, int s) {
        DateTimeStringUtils.ymd(b, year, month, day);
        b.append(' ');
        DateTimeStringUtils.hms(b, h, m, s);
        return b;
    }

    static StringBuilder ymd(StringBuilder b, int year, int month, int day) {
        DateTimeStringUtils.int4(b, year);
        b.append('-');
        DateTimeStringUtils.int2(b, month);
        b.append('-');
        DateTimeStringUtils.int2(b, day);
        return b;
    }

    private static void int4(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 1000 % 10));
        buf.append((char)(48 + i / 100 % 10));
        buf.append((char)(48 + i / 10 % 10));
        buf.append((char)(48 + i % 10));
    }

    private static void int2(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 10 % 10));
        buf.append((char)(48 + i % 10));
    }

    static boolean isValidTimeZone(String timeZone) {
        if (timeZone.equals("GMT")) {
            return true;
        }
        String id = TimeZone.getTimeZone(timeZone).getID();
        return !id.equals("GMT");
    }
}

