/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hive.common.type.RandomTypeUtil;
import org.apache.hadoop.hive.llap.io.ChunkedInputStream;
import org.apache.hadoop.hive.llap.io.ChunkedOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class TestChunkedInputStream {
    static int bufferSize = 128;
    static Random rand = new Random();
    static String alphabet = "abcdefghijklmnopqrstuvwxyz";

    static void runTest(Runnable writer, Runnable reader, TestStreams streams) throws Exception {
        Thread writerThread = new Thread(writer);
        Thread readerThread = new Thread(reader);
        writerThread.start();
        readerThread.start();
        writerThread.join();
        readerThread.join();
    }

    @Test
    public void testBasicUsage() throws Exception {
        List values = Arrays.asList({1}, {2}, RandomTypeUtil.getRandString((Random)rand, (String)alphabet, (int)99).getBytes(), RandomTypeUtil.getRandString((Random)rand, (String)alphabet, (int)1024).getBytes());
        TestStreams nonChunkedStreams = new TestStreams(false);
        nonChunkedStreams.values = values;
        BasicUsageWriter writer1 = new BasicUsageWriter(nonChunkedStreams, false, false);
        BasicUsageReader reader1 = new BasicUsageReader(nonChunkedStreams);
        TestChunkedInputStream.runTest(writer1, reader1, nonChunkedStreams);
        Assert.assertTrue((boolean)reader1.allValuesRead);
        Assert.assertNull((Object)writer1.getError());
        Assert.assertNull((Object)reader1.getError());
        TestStreams chunkedStreams = new TestStreams(true);
        chunkedStreams.values = values;
        BasicUsageWriter writer2 = new BasicUsageWriter(chunkedStreams, false, false);
        BasicUsageReader reader2 = new BasicUsageReader(chunkedStreams);
        TestChunkedInputStream.runTest(writer2, reader2, chunkedStreams);
        Assert.assertTrue((boolean)reader2.allValuesRead);
        Assert.assertTrue((boolean)((ChunkedInputStream)chunkedStreams.in).isEndOfData());
        Assert.assertNull((Object)writer2.getError());
        Assert.assertNull((Object)reader2.getError());
    }

    @Test
    public void testAbruptlyClosedOutput() throws Exception {
        List values = Arrays.asList({1}, {2}, RandomTypeUtil.getRandString((Random)rand, (String)alphabet, (int)99).getBytes(), RandomTypeUtil.getRandString((Random)rand, (String)alphabet, (int)1024).getBytes());
        TestStreams nonChunkedStreams = new TestStreams(false);
        nonChunkedStreams.values = values;
        BasicUsageWriter writer1 = new BasicUsageWriter(nonChunkedStreams, true, true);
        BasicUsageReader reader1 = new BasicUsageReader(nonChunkedStreams);
        TestChunkedInputStream.runTest(writer1, reader1, nonChunkedStreams);
        Assert.assertTrue((boolean)reader1.allValuesRead);
        Assert.assertNull((Object)writer1.getError());
        Assert.assertNull((Object)reader1.getError());
        TestStreams chunkedStreams = new TestStreams(true);
        chunkedStreams.values = values;
        BasicUsageWriter writer2 = new BasicUsageWriter(chunkedStreams, true, true);
        BasicUsageReader reader2 = new BasicUsageReader(chunkedStreams);
        TestChunkedInputStream.runTest(writer2, reader2, chunkedStreams);
        Assert.assertTrue((boolean)reader2.allValuesRead);
        Assert.assertFalse((boolean)((ChunkedInputStream)chunkedStreams.in).isEndOfData());
        Assert.assertNotNull((Object)writer2.getError());
        Assert.assertNotNull((Object)reader2.getError());
    }

    static class TestStreams {
        PipedOutputStream pout = new PipedOutputStream();
        OutputStream out;
        PipedInputStream pin = new PipedInputStream(this.pout);
        InputStream in;
        List<byte[]> values;

        public TestStreams(boolean useChunkedStream) throws Exception {
            if (useChunkedStream) {
                this.out = new ChunkedOutputStream((OutputStream)this.pout, bufferSize, "test");
                this.in = new ChunkedInputStream((InputStream)this.pin, "test");
            } else {
                this.out = new FilterOutputStream(this.pout);
                this.in = new MyFilterInputStream(this.pin);
            }
        }

        public void close() {
            try {
                this.pout.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.pin.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class MyFilterInputStream
    extends FilterInputStream {
        public MyFilterInputStream(InputStream in) {
            super(in);
        }
    }

    static class BasicUsageReader
    extends StreamTester
    implements Runnable {
        TestStreams streams;
        boolean allValuesRead = false;

        public BasicUsageReader(TestStreams streams) {
            this.streams = streams;
        }

        void readFully(InputStream in, byte[] readValue, int numBytes) throws IOException {
            int read;
            for (int bytesRead = 0; bytesRead < numBytes; bytesRead += read) {
                read = in.read(readValue, bytesRead, numBytes - bytesRead);
                if (read > 0) continue;
                throw new IOException("Unexpected read length " + read);
            }
        }

        @Override
        public void run() {
            try {
                for (byte[] value : this.streams.values) {
                    byte[] readValue = new byte[value.length];
                    this.readFully(this.streams.in, readValue, readValue.length);
                    Assert.assertArrayEquals((byte[])value, (byte[])readValue);
                }
                this.allValuesRead = true;
                Assert.assertEquals((long)-1L, (long)this.streams.in.read());
            }
            catch (Exception err) {
                err.printStackTrace();
                this.error = err;
            }
        }
    }

    static class BasicUsageWriter
    extends StreamTester
    implements Runnable {
        TestStreams streams;
        boolean flushCout;
        boolean closePoutEarly;

        public BasicUsageWriter(TestStreams streams, boolean flushCout, boolean closePoutEarly) {
            this.streams = streams;
            this.flushCout = flushCout;
            this.closePoutEarly = closePoutEarly;
        }

        @Override
        public void run() {
            try {
                for (byte[] value : this.streams.values) {
                    this.streams.out.write(value, 0, value.length);
                }
                if (this.flushCout) {
                    this.streams.out.flush();
                }
                if (this.closePoutEarly) {
                    this.streams.pout.close();
                }
                this.streams.out.close();
            }
            catch (Exception err) {
                err.printStackTrace();
                this.error = err;
            }
        }
    }

    static class StreamTester {
        Exception error = null;

        StreamTester() {
        }

        public Exception getError() {
            return this.error;
        }

        public void setError(Exception error) {
            this.error = error;
        }
    }
}

