/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.llap.cache.BuddyAllocator;
import org.apache.hadoop.hive.llap.cache.LlapAllocatorBuffer;
import org.apache.hadoop.hive.llap.cache.MemoryManager;
import org.apache.hadoop.hive.llap.cache.TestBuddyAllocator;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBuddyAllocatorForceEvict {
    private static final Logger LOG = LoggerFactory.getLogger(TestBuddyAllocatorForceEvict.class);
    private static final TestBuddyAllocator.DummyMemoryManager MM = new TestBuddyAllocator.DummyMemoryManager();
    private static final LlapDaemonCacheMetrics METRICS = LlapDaemonCacheMetrics.create((String)"test", (String)"1");

    @Test(timeout=6000L)
    public void testSimple() {
        this.runSimpleTests(false);
        this.runSimpleTests(true);
    }

    public void runSimpleTests(boolean isBruteOnly) {
        this.runSimple1to2Discard(TestBuddyAllocatorForceEvict.create(1024, 1, 1024, true, isBruteOnly), 256);
        this.runSimple1to2Discard(TestBuddyAllocatorForceEvict.create(1024, 1, 1024, false, isBruteOnly), 256);
        this.runSimple1to2Discard(TestBuddyAllocatorForceEvict.create(512, 2, 1024, false, isBruteOnly), 256);
    }

    @Test(timeout=6000L)
    public void testSmallBlocks() {
        this.runSmallBlockersTests(false);
        this.runSmallBlockersTests(true);
    }

    public void runSmallBlockersTests(boolean isBruteOnly) {
        this.runSmallBlockersDiscard(TestBuddyAllocatorForceEvict.create(1024, 1, 1024, false, isBruteOnly), 128, false, false);
        this.runSmallBlockersDiscard(TestBuddyAllocatorForceEvict.create(1024, 1, 1024, false, isBruteOnly), 128, true, false);
        this.runSmallBlockersDiscard(TestBuddyAllocatorForceEvict.create(1024, 1, 1024, false, isBruteOnly), 128, false, true);
        this.runSmallBlockersDiscard(TestBuddyAllocatorForceEvict.create(1024, 1, 1024, false, isBruteOnly), 128, true, true);
        this.runSmallBlockersDiscard(TestBuddyAllocatorForceEvict.create(512, 2, 1024, false, isBruteOnly), 128, false, false);
        this.runSmallBlockersDiscard(TestBuddyAllocatorForceEvict.create(512, 2, 1024, false, isBruteOnly), 128, true, false);
        this.runSmallBlockersDiscard(TestBuddyAllocatorForceEvict.create(512, 2, 1024, false, isBruteOnly), 128, false, true);
        this.runSmallBlockersDiscard(TestBuddyAllocatorForceEvict.create(512, 2, 1024, false, isBruteOnly), 128, true, true);
    }

    @Test(timeout=6000L)
    public void testZebra() {
        this.runZebraTests(false);
        this.runZebraTests(true);
    }

    public void runZebraTests(boolean isBruteOnly) {
        TestBuddyAllocatorForceEvict.runZebraDiscard(TestBuddyAllocatorForceEvict.create(1024, 1, 1024, false, isBruteOnly), 32, 16, 1);
        TestBuddyAllocatorForceEvict.runZebraDiscard(TestBuddyAllocatorForceEvict.create(1024, 1, 1024, false, isBruteOnly), 64, 8, 1);
        TestBuddyAllocatorForceEvict.runZebraDiscard(TestBuddyAllocatorForceEvict.create(1024, 1, 1024, false, isBruteOnly), 32, 16, 2);
        TestBuddyAllocatorForceEvict.runZebraDiscard(TestBuddyAllocatorForceEvict.create(1024, 1, 1024, false, isBruteOnly), 32, 16, 4);
        TestBuddyAllocatorForceEvict.runZebraDiscard(TestBuddyAllocatorForceEvict.create(512, 2, 1024, false, isBruteOnly), 32, 16, 1);
        TestBuddyAllocatorForceEvict.runZebraDiscard(TestBuddyAllocatorForceEvict.create(512, 2, 1024, false, isBruteOnly), 64, 8, 1);
        TestBuddyAllocatorForceEvict.runZebraDiscard(TestBuddyAllocatorForceEvict.create(512, 2, 1024, false, isBruteOnly), 32, 16, 2);
        TestBuddyAllocatorForceEvict.runZebraDiscard(TestBuddyAllocatorForceEvict.create(256, 4, 1024, false, isBruteOnly), 32, 16, 2);
        TestBuddyAllocatorForceEvict.runZebraDiscard(TestBuddyAllocatorForceEvict.create(256, 4, 1024, false, isBruteOnly), 32, 16, 4);
    }

    @Test(timeout=6000L)
    public void testUnevenZebra() {
        this.runUnevenZebraTests(false);
        this.runUnevenZebraTests(true);
    }

    public void runUnevenZebraTests(boolean isBruteOnly) {
        TestBuddyAllocatorForceEvict.runCustomDiscard(TestBuddyAllocatorForceEvict.create(1024, 1, 1024, false, isBruteOnly), new int[]{256, 256, 128, 128, 128, 128}, new int[]{0, 2, 4}, 512);
        TestBuddyAllocatorForceEvict.runCustomDiscard(TestBuddyAllocatorForceEvict.create(1024, 1, 1024, false, isBruteOnly), new int[]{256, 256, 64, 64, 64, 64, 64, 64, 64, 64}, new int[]{0, 2, 4, 6, 8}, 512);
        TestBuddyAllocatorForceEvict.runCustomDiscard(TestBuddyAllocatorForceEvict.create(512, 2, 1024, false, isBruteOnly), new int[]{256, 256, 128, 128, 128, 128}, new int[]{0, 2, 4}, 512);
        TestBuddyAllocatorForceEvict.runCustomDiscard(TestBuddyAllocatorForceEvict.create(512, 2, 1024, false, isBruteOnly), new int[]{256, 256, 64, 64, 64, 64, 64, 64, 64, 64}, new int[]{0, 2, 4, 6, 8}, 512);
    }

    @Test(timeout=6000L)
    public void testComplex1() {
        this.runComplexTests(false);
        this.runComplexTests(true);
    }

    public void runComplexTests(boolean isBruteOnly) {
        TestBuddyAllocatorForceEvict.runCustomDiscard(TestBuddyAllocatorForceEvict.create(1024, 1, 1024, false, isBruteOnly), new int[]{256, 128, 64, 64, 256, 64, 64, 128}, new int[]{0, 3, 6, 7}, 512);
        TestBuddyAllocatorForceEvict.runCustomDiscard(TestBuddyAllocatorForceEvict.create(1024, 1, 1024, false, isBruteOnly), new int[]{256, 64, 64, 64, 64, 256, 64, 64, 128}, new int[]{0, 4, 7, 8}, 512);
        TestBuddyAllocatorForceEvict.runCustomDiscard(TestBuddyAllocatorForceEvict.create(512, 2, 1024, false, isBruteOnly), new int[]{256, 128, 64, 64, 256, 64, 64, 128}, new int[]{0, 3, 6, 7}, 512);
        TestBuddyAllocatorForceEvict.runCustomDiscard(TestBuddyAllocatorForceEvict.create(512, 2, 1024, false, isBruteOnly), new int[]{256, 64, 64, 64, 64, 256, 64, 64, 128}, new int[]{0, 4, 7, 8}, 512);
    }

    @Test(timeout=200000L)
    public void testMtt() {
        int baseAllocSizeLog2 = 3;
        int maxAllocSizeLog2 = 10;
        int totalSize = 8192;
        int baseAllocSize = 8;
        int maxAllocSize = 1024;
        int threadCount = 8;
        int iterCount = 500;
        BuddyAllocator a = TestBuddyAllocatorForceEvict.create(1024, 4, 8192, true, false);
        ExecutorService executor = Executors.newFixedThreadPool(9);
        CountDownLatch cdlIn = new CountDownLatch(8);
        CountDownLatch cdlOut = new CountDownLatch(1);
        FutureTask[] allocTasks = new FutureTask[8];
        FutureTask<Void> dumpTask = TestBuddyAllocatorForceEvict.createAllocatorDumpTask(a);
        int allocSize = 8;
        int i = 0;
        while (allocSize <= 1024) {
            allocTasks[i] = new FutureTask<MttTestCallableResult>(new MttTestCallable(cdlIn, cdlOut, a, allocSize, 8192 / allocSize, 500));
            executor.execute(allocTasks[i]);
            allocSize <<= 1;
            ++i;
        }
        executor.execute(dumpTask);
        TestBuddyAllocatorForceEvict.runMttTest(a, allocTasks, cdlIn, cdlOut, dumpTask, null, null, 8192, 1024);
    }

    public static void runMttTest(BuddyAllocator a, FutureTask<?>[] allocTasks, CountDownLatch cdlIn, CountDownLatch cdlOut, FutureTask<Void> dumpTask, FutureTask<Void> defragTask, AtomicBoolean defragStopped, int totalSize, int maxAllocSize) {
        Throwable t;
        block11: {
            t = null;
            try {
                cdlIn.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            cdlOut.countDown();
            for (int i = 0; i < allocTasks.length; ++i) {
                try {
                    Object result = allocTasks[i].get();
                    LOG.info("" + result);
                    continue;
                }
                catch (Throwable tt) {
                    LOG.error("Test callable failed", tt);
                    if (t != null) continue;
                    a.dumpTestLog();
                    t = tt;
                }
            }
            dumpTask.cancel(true);
            if (defragTask != null) {
                defragStopped.set(true);
                try {
                    defragTask.get();
                }
                catch (Throwable tt) {
                    LOG.error("Defragmentation thread failed", t);
                    if (t != null) break block11;
                    a.dumpTestLog();
                    t = tt;
                }
            }
        }
        if (t != null) {
            throw new RuntimeException("One of the errors", t);
        }
        LOG.info("Allocator state after all the tasks: " + a.testDump());
        try {
            TestBuddyAllocatorForceEvict.allocate(a, totalSize / maxAllocSize, maxAllocSize, 0);
        }
        catch (Throwable tt) {
            a.dumpTestLog();
            throw tt;
        }
    }

    public static FutureTask<Void> createAllocatorDumpTask(final BuddyAllocator a) {
        return new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int logs = 40000;
                while (--logs >= 0) {
                    LOG.info("Allocator state (MTT): " + a.testDump());
                    Thread.sleep(10L);
                }
                return null;
            }
        });
    }

    private static void runCustomDiscard(BuddyAllocator a, int[] sizes, int[] dealloc, int size) {
        LlapAllocatorBuffer[] initial = TestBuddyAllocatorForceEvict.prepareCustomFragmentedAllocator(a, sizes, dealloc, true);
        LlapAllocatorBuffer after = TestBuddyAllocatorForceEvict.allocate(a, 1, size, initial.length + 1)[0];
        LOG.info("After: " + a.testDump());
        for (int i = 0; i < initial.length; ++i) {
            if (initial[i] == null) continue;
            TestBuddyAllocatorForceEvict.checkTestValue(initial[i], i + 1, null, false);
            a.deallocate((MemoryBuffer)initial[i]);
        }
        TestBuddyAllocatorForceEvict.checkTestValue(after, initial.length + 1, null, true);
        a.deallocate((MemoryBuffer)after);
    }

    private static void runZebraDiscard(BuddyAllocator a, int baseSize, int pairCount, int allocs) {
        LlapAllocatorBuffer[] initial = TestBuddyAllocatorForceEvict.prepareZebraFragmentedAllocator(a, baseSize, pairCount, true);
        int allocFraction = allocs * 2;
        int bigAllocSize = pairCount * 2 * baseSize / allocFraction;
        LlapAllocatorBuffer[] after = TestBuddyAllocatorForceEvict.allocate(a, allocs, bigAllocSize, 1 + initial.length);
        LOG.info("After: " + a.testDump());
        for (int i = 0; i < pairCount; ++i) {
            int ix = (i << 1) + 1;
            TestBuddyAllocatorForceEvict.checkTestValue(initial[ix], ix + 1, null, false);
        }
        TestBuddyAllocatorForceEvict.checkTestValue(after[0], 1 + initial.length, null, true);
    }

    public static LlapAllocatorBuffer[] prepareZebraFragmentedAllocator(BuddyAllocator a, int baseSize, int pairCount, boolean doIncRef) {
        LlapAllocatorBuffer[] initial = TestBuddyAllocatorForceEvict.allocate(a, pairCount * 2, baseSize, 1, doIncRef);
        for (int i = 0; i < pairCount; ++i) {
            a.deallocate((MemoryBuffer)initial[i << 1]);
            initial[i << 1] = null;
        }
        LOG.info("Before: " + a.testDump());
        a.setOomLoggingForTest(true);
        return initial;
    }

    private void runSimple1to2Discard(BuddyAllocator a, int baseSize) {
        LlapAllocatorBuffer[] initial = TestBuddyAllocatorForceEvict.prepareSimpleFragmentedAllocator(a, baseSize, true);
        LlapAllocatorBuffer[] after = TestBuddyAllocatorForceEvict.allocate(a, 1, baseSize * 2, 1 + initial.length);
        LOG.info("After: " + a.testDump());
        TestBuddyAllocatorForceEvict.checkInitialValues(initial, 0, 2);
        TestBuddyAllocatorForceEvict.checkTestValue(after[0], 1 + initial.length, null, true);
        a.deallocate((MemoryBuffer)initial[0]);
        a.deallocate((MemoryBuffer)initial[2]);
        a.deallocate((MemoryBuffer)after[0]);
    }

    public static LlapAllocatorBuffer[] prepareSimpleFragmentedAllocator(BuddyAllocator a, int baseSize, boolean doIncRef) {
        LlapAllocatorBuffer[] initial = TestBuddyAllocatorForceEvict.allocate(a, 4, baseSize, 1, doIncRef);
        TestBuddyAllocatorForceEvict.checkInitialValues(initial, 0, 2);
        a.deallocate((MemoryBuffer)initial[1]);
        a.deallocate((MemoryBuffer)initial[3]);
        LOG.info("Before: " + a.testDump());
        a.setOomLoggingForTest(true);
        return initial;
    }

    private void runSmallBlockersDiscard(BuddyAllocator a, int baseSize, boolean deallocOneFirst, boolean deallocOneSecond) {
        LlapAllocatorBuffer[] initial = TestBuddyAllocatorForceEvict.prepareAllocatorWithSmallFragments(a, baseSize, deallocOneFirst, deallocOneSecond, true);
        int bigAllocSize = baseSize * 4;
        LlapAllocatorBuffer[] after = TestBuddyAllocatorForceEvict.allocate(a, 1, bigAllocSize, 1 + initial.length);
        LOG.info("After: " + a.testDump());
        TestBuddyAllocatorForceEvict.checkInitialValues(initial, 2, 4);
        TestBuddyAllocatorForceEvict.checkTestValue(after[0], 1 + initial.length, null, true);
    }

    public static LlapAllocatorBuffer[] prepareAllocatorWithSmallFragments(BuddyAllocator a, int baseSize, boolean deallocOneFirst, boolean deallocOneSecond, boolean doIncRef) {
        int offset = 0;
        LlapAllocatorBuffer[] initial = new LlapAllocatorBuffer[6];
        initial[offset++] = TestBuddyAllocatorForceEvict.allocate(a, 1, baseSize * 2, offset + 1, doIncRef)[0];
        LlapAllocatorBuffer[] tmp = TestBuddyAllocatorForceEvict.allocate(a, 2, baseSize, offset + 1);
        System.arraycopy(tmp, 0, initial, offset, 2);
        offset += 2;
        initial[offset++] = TestBuddyAllocatorForceEvict.allocate(a, 1, baseSize * 2, offset + 1, doIncRef)[0];
        tmp = TestBuddyAllocatorForceEvict.allocate(a, 2, baseSize, offset + 1);
        System.arraycopy(tmp, 0, initial, offset, 2);
        if (deallocOneFirst) {
            a.deallocate((MemoryBuffer)initial[1]);
        }
        if (deallocOneSecond) {
            a.deallocate((MemoryBuffer)initial[5]);
        }
        a.deallocate((MemoryBuffer)initial[0]);
        a.deallocate((MemoryBuffer)initial[3]);
        LOG.info("Before: " + a.testDump());
        a.setOomLoggingForTest(true);
        return initial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkInitialValues(LlapAllocatorBuffer[] bufs, int ... indexes) {
        for (int index : indexes) {
            LlapAllocatorBuffer buf = bufs[index];
            if (!TestBuddyAllocatorForceEvict.incRefIfNotEvicted(buf, false)) continue;
            try {
                TestBuddyAllocatorForceEvict.checkTestValue(buf, index + 1, null, false);
            }
            finally {
                buf.decRef();
            }
        }
    }

    private static boolean incRefIfNotEvicted(LlapAllocatorBuffer buf, boolean mustExist) {
        int rc = buf.tryIncRef();
        if (rc == -2) {
            Assert.fail((String)("Failed to incref (bad state) " + buf));
        }
        if (rc <= 0 && mustExist) {
            Assert.fail((String)("Failed to incref (evicted) " + buf));
        }
        return rc > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkTestValue(LlapAllocatorBuffer mem, long testValue, String str, boolean mustExist) {
        if (!TestBuddyAllocatorForceEvict.incRefIfNotEvicted(mem, mustExist)) {
            return;
        }
        try {
            TestBuddyAllocator.checkTestValue((MemoryBuffer)mem, testValue, str);
        }
        finally {
            mem.decRef();
        }
    }

    public static BuddyAllocator create(int max, int arenas, int total, boolean isShortcut, boolean isBruteForceOnly) {
        BuddyAllocator result = new BuddyAllocator(false, false, 8, max, arenas, (long)total, 0L, null, (MemoryManager)MM, METRICS, isBruteForceOnly ? "brute" : null);
        if (!isShortcut) {
            result.disableDefragShortcutForTest();
        }
        result.setOomLoggingForTest(false);
        return result;
    }

    private static LlapAllocatorBuffer[] allocate(BuddyAllocator a, int count, int size, int baseValue) {
        return TestBuddyAllocatorForceEvict.allocate(a, count, size, baseValue, true);
    }

    public static LlapAllocatorBuffer[] allocate(BuddyAllocator a, int count, int size, int baseValue, boolean doIncRef) {
        LlapAllocatorBuffer[] allocs = new LlapAllocatorBuffer[count];
        try {
            a.allocateMultiple((MemoryBuffer[])allocs, size);
        }
        catch (Allocator.AllocatorOutOfMemoryException ex) {
            LOG.error("Failed to allocate " + allocs.length + " of " + size + "; " + a.testDump());
            throw ex;
        }
        for (int i = 0; i < count; ++i) {
            if (doIncRef) {
                int rc = allocs[i].incRef();
                Assert.assertTrue((rc > 0 ? 1 : 0) != 0);
            }
            TestBuddyAllocator.putTestValue((MemoryBuffer)allocs[i], baseValue + i);
            if (!doIncRef) continue;
            allocs[i].decRef();
        }
        return allocs;
    }

    public static LlapAllocatorBuffer[] prepareCustomFragmentedAllocator(BuddyAllocator a, int[] sizes, int[] dealloc, boolean doIncRef) {
        int i;
        LlapAllocatorBuffer[] initial = new LlapAllocatorBuffer[sizes.length];
        for (i = 0; i < sizes.length; ++i) {
            initial[i] = TestBuddyAllocatorForceEvict.allocate(a, 1, sizes[i], i + 1, doIncRef)[0];
        }
        for (i = 0; i < dealloc.length; ++i) {
            a.deallocate((MemoryBuffer)initial[dealloc[i]]);
            initial[dealloc[i]] = null;
        }
        LOG.info("Before: " + a.testDump());
        a.setOomLoggingForTest(true);
        return initial;
    }

    static class MttTestCallable
    implements Callable<MttTestCallableResult> {
        private final CountDownLatch cdlIn;
        private final CountDownLatch cdlOut;
        private final int allocSize;
        private final int allocCount;
        private final int iterCount;
        private final BuddyAllocator a;

        public MttTestCallable(CountDownLatch cdlIn, CountDownLatch cdlOut, BuddyAllocator a, int allocSize, int allocCount, int iterCount) {
            this.cdlIn = cdlIn;
            this.cdlOut = cdlOut;
            this.a = a;
            this.allocSize = allocSize;
            this.allocCount = allocCount;
            this.iterCount = iterCount;
        }

        @Override
        public MttTestCallableResult call() throws Exception {
            LOG.info(Thread.currentThread().getId() + " thread starts");
            TestBuddyAllocator.syncThreadStart(this.cdlIn, this.cdlOut);
            MttTestCallableResult result = new MttTestCallableResult();
            result.allocSize = this.allocSize;
            ArrayList<MemoryBuffer> allocs = new ArrayList<MemoryBuffer>(this.allocCount);
            LlapAllocatorBuffer[] dest = new LlapAllocatorBuffer[1];
            for (int i = 0; i < this.iterCount; ++i) {
                for (int j = 0; j < this.allocCount; ++j) {
                    try {
                        dest[0] = null;
                        this.a.allocateMultiple((MemoryBuffer[])dest, this.allocSize);
                        MemoryBuffer buf = dest[0];
                        Assert.assertTrue((buf.incRef() > 0 ? 1 : 0) != 0);
                        allocs.add(buf);
                        ++result.successes;
                        buf.decRef();
                        continue;
                    }
                    catch (Allocator.AllocatorOutOfMemoryException ex) {
                        ++result.ooms;
                        continue;
                    }
                    catch (Throwable ex) {
                        LOG.error("Failed", ex);
                        throw new Exception(ex);
                    }
                }
                for (MemoryBuffer buf : allocs) {
                    try {
                        this.a.deallocate(buf);
                    }
                    catch (Throwable ex) {
                        LOG.error("Failed", ex);
                        throw new Exception(ex);
                    }
                }
                allocs.clear();
            }
            return result;
        }
    }

    static class MttTestCallableResult {
        public int successes;
        public int ooms;
        public int allocSize;

        MttTestCallableResult() {
        }

        public String toString() {
            return "allocation size " + this.allocSize + ": " + this.successes + " allocations, " + this.ooms + " OOMs";
        }
    }
}

