/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.security;

import java.io.IOException;
import javax.crypto.SecretKey;
import org.apache.hadoop.hive.llap.security.LlapSigner;
import org.apache.hadoop.hive.llap.security.LlapSignerImpl;
import org.apache.hadoop.hive.llap.security.SigningSecretManager;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLlapSignerImpl {
    private static final Logger LOG = LoggerFactory.getLogger(TestLlapSignerImpl.class);

    @Test(timeout=10000L)
    public void testSigning() throws Exception {
        FakeSecretManager fsm = new FakeSecretManager();
        fsm.startThreads();
        LlapSignerImpl signer = new LlapSignerImpl((SigningSecretManager)fsm);
        byte theByte = 1;
        TestSignable in = new TestSignable(theByte);
        theByte = (byte)(theByte + 1);
        TestSignable in2 = new TestSignable(theByte);
        LlapSigner.SignedMessage sm = signer.serializeAndSign((LlapSigner.Signable)in);
        LlapSigner.SignedMessage sm2 = signer.serializeAndSign((LlapSigner.Signable)in2);
        TestSignable out = TestSignable.deserialize(sm.message);
        TestSignable out2 = TestSignable.deserialize(sm2.message);
        Assert.assertEquals((Object)in, (Object)out);
        Assert.assertEquals((Object)in2, (Object)out2);
        signer.checkSignature(sm.message, sm.signature, out.masterKeyId);
        signer.checkSignature(sm2.message, sm2.signature, out2.masterKeyId);
        try {
            signer.checkSignature(sm.message, sm2.signature, out.masterKeyId);
            Assert.fail((String)"Didn't throw");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        int index = sm.signature.length / 2;
        sm.signature[index] = (byte)(sm.signature[index] + 1);
        try {
            signer.checkSignature(sm.message, sm.signature, out.masterKeyId);
            Assert.fail((String)"Didn't throw");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        sm.signature[index] = (byte)(sm.signature[index] - 1);
        fsm = this.rollKey(fsm, out.masterKeyId);
        signer = new LlapSignerImpl((SigningSecretManager)fsm);
        sm2 = signer.serializeAndSign((LlapSigner.Signable)in2);
        out2 = TestSignable.deserialize(sm2.message);
        Assert.assertNotEquals((long)out.masterKeyId, (long)out2.masterKeyId);
        Assert.assertEquals((Object)in2, (Object)out2);
        signer.checkSignature(sm2.message, sm2.signature, out2.masterKeyId);
        signer.checkSignature(sm.message, sm.signature, out.masterKeyId);
        try {
            signer.checkSignature(sm2.message, sm2.signature, out.masterKeyId);
            Assert.fail((String)"Didn't throw");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        fsm = this.rollKey(fsm, out2.masterKeyId);
        signer = new LlapSignerImpl((SigningSecretManager)fsm);
        signer.checkSignature(sm2.message, sm2.signature, out2.masterKeyId);
        try {
            signer.checkSignature(sm.message, sm.signature, out.masterKeyId);
            Assert.fail((String)"Didn't throw");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        fsm.stopThreads();
    }

    private FakeSecretManager rollKey(FakeSecretManager fsm, int idToPreserve) throws IOException {
        DelegationKey dk = fsm.getDelegationKey(idToPreserve);
        DelegationKey curDk = fsm.getCurrentKey();
        if (curDk.getKeyId() != idToPreserve) {
            LOG.warn("The current key is not the one we expect; key rolled in background? Signed with " + idToPreserve + " but got " + curDk.getKeyId());
        }
        Assert.assertNotNull((Object)dk);
        Assert.assertEquals((long)idToPreserve, (long)dk.getKeyId());
        fsm.stopThreads();
        fsm = new FakeSecretManager();
        fsm.addKey(dk);
        Assert.assertNotNull((String)"Couldn't add key", (Object)fsm.getDelegationKey(dk.getKeyId()));
        fsm.startThreads();
        return fsm;
    }

    private static class FakeSecretManager
    extends AbstractDelegationTokenSecretManager<AbstractDelegationTokenIdentifier>
    implements SigningSecretManager {
        public FakeSecretManager() {
            super(10000000L, 10000000L, 10000000L, 10000000L);
        }

        public DelegationKey getCurrentKey() {
            return this.getDelegationKey(this.getCurrentKeyId());
        }

        public DelegationKey getDelegationKey(int keyId) {
            return super.getDelegationKey(keyId);
        }

        public byte[] signWithKey(byte[] message, DelegationKey key) {
            return FakeSecretManager.createPassword((byte[])message, (SecretKey)key.getKey());
        }

        public byte[] signWithKey(byte[] message, int keyId) throws SecurityException {
            DelegationKey key = this.getDelegationKey(keyId);
            if (key == null) {
                throw new SecurityException("The key ID " + keyId + " was not found");
            }
            return FakeSecretManager.createPassword((byte[])message, (SecretKey)key.getKey());
        }

        public AbstractDelegationTokenIdentifier createIdentifier() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            this.stopThreads();
        }
    }

    private static class TestSignable
    implements LlapSigner.Signable {
        public int masterKeyId;
        public byte index;

        public TestSignable(byte i) {
            this.index = i;
        }

        public TestSignable(int keyId, byte b) {
            this.masterKeyId = keyId;
            this.index = b;
        }

        public void setSignInfo(int masterKeyId) {
            this.masterKeyId = masterKeyId;
        }

        public byte[] serialize() throws IOException {
            DataOutputBuffer dob = new DataOutputBuffer(5);
            dob.writeInt(this.masterKeyId);
            dob.write((int)this.index);
            byte[] b = dob.getData();
            dob.close();
            return b;
        }

        public static TestSignable deserialize(byte[] bytes) throws IOException {
            DataInputBuffer db = new DataInputBuffer();
            db.reset(bytes, bytes.length);
            int keyId = db.readInt();
            byte b = db.readByte();
            db.close();
            return new TestSignable(keyId, b);
        }

        public int hashCode() {
            return 31 * this.index + this.masterKeyId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TestSignable)) {
                return false;
            }
            TestSignable other = (TestSignable)obj;
            return this.index == other.index && this.masterKeyId == other.masterKeyId;
        }
    }
}

