/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cache.EvictionListener;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LlapDataBuffer;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheImpl;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheMemoryManager;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.cache.LowLevelLrfuCachePolicy;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLowLevelLrfuCachePolicy {
    private static final Logger LOG = LoggerFactory.getLogger(TestLowLevelLrfuCachePolicy.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegression_HIVE_12178() throws Exception {
        LOG.info("Testing wrong list status after eviction");
        EvictionTracker et = new EvictionTracker();
        int memSize = 2;
        Configuration conf = new Configuration();
        conf.setDouble(HiveConf.ConfVars.LLAP_LRFU_LAMBDA.varname, 1.0);
        final LowLevelLrfuCachePolicy lrfu = new LowLevelLrfuCachePolicy(1, (long)memSize, conf);
        Field f = LowLevelLrfuCachePolicy.class.getDeclaredField("listLock");
        f.setAccessible(true);
        ReentrantLock listLock = (ReentrantLock)f.get(lrfu);
        LowLevelCacheMemoryManager mm = new LowLevelCacheMemoryManager((long)memSize, (LowLevelCachePolicy)lrfu, LlapDaemonCacheMetrics.create((String)"test", (String)"1"));
        lrfu.setEvictionListener((EvictionListener)et);
        final LlapDataBuffer buffer1 = LowLevelCacheImpl.allocateFake();
        LlapDataBuffer buffer2 = LowLevelCacheImpl.allocateFake();
        Assert.assertTrue((boolean)this.cache(mm, lrfu, et, buffer1));
        Assert.assertTrue((boolean)this.cache(mm, lrfu, et, buffer2));
        buffer1.incRef();
        Assert.assertEquals((long)-2L, (long)buffer1.indexInHeap);
        listLock.lock();
        try {
            Thread otherThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    lrfu.notifyLock((LlapCacheableBuffer)buffer1);
                }
            });
            otherThread.start();
            otherThread.join();
        }
        finally {
            listLock.unlock();
        }
        mm.reserveMemory(1L, false);
        Assert.assertSame((Object)buffer2, (Object)et.evicted.get(0));
        TestLowLevelLrfuCachePolicy.unlock(lrfu, buffer1);
    }

    @Test
    public void testHeapSize2() {
        this.testHeapSize(2);
    }

    @Test
    public void testHeapSize8() {
        this.testHeapSize(8);
    }

    @Test
    public void testHeapSize30() {
        this.testHeapSize(30);
    }

    @Test
    public void testHeapSize64() {
        this.testHeapSize(64);
    }

    @Test
    public void testLfuExtreme() {
        int i;
        int heapSize = 4;
        LOG.info("Testing lambda 0 (LFU)");
        Random rdm = new Random(1234L);
        Configuration conf = new Configuration();
        ArrayList<LlapDataBuffer> inserted = new ArrayList<LlapDataBuffer>(heapSize);
        conf.setFloat(HiveConf.ConfVars.LLAP_LRFU_LAMBDA.varname, 0.0f);
        EvictionTracker et = new EvictionTracker();
        LowLevelLrfuCachePolicy lfu = new LowLevelLrfuCachePolicy(1, (long)heapSize, conf);
        LowLevelCacheMemoryManager mm = new LowLevelCacheMemoryManager((long)heapSize, (LowLevelCachePolicy)lfu, LlapDaemonCacheMetrics.create((String)"test", (String)"1"));
        lfu.setEvictionListener((EvictionListener)et);
        for (i = 0; i < heapSize; ++i) {
            LlapDataBuffer buffer = LowLevelCacheImpl.allocateFake();
            Assert.assertTrue((boolean)this.cache(mm, lfu, et, buffer));
            inserted.add(buffer);
        }
        Collections.shuffle(inserted, rdm);
        for (i = inserted.size() - 1; i >= 0; --i) {
            for (int j = 0; j < i + 1; ++j) {
                lfu.notifyLock((LlapCacheableBuffer)inserted.get(i));
                lfu.notifyUnlock((LlapCacheableBuffer)inserted.get(i));
            }
        }
        this.verifyOrder(mm, lfu, et, inserted, null);
    }

    @Test
    public void testLruExtreme() {
        int i;
        int heapSize = 4;
        LOG.info("Testing lambda 1 (LRU)");
        Random rdm = new Random(1234L);
        Configuration conf = new Configuration();
        ArrayList<LlapDataBuffer> inserted = new ArrayList<LlapDataBuffer>(heapSize);
        conf.setFloat(HiveConf.ConfVars.LLAP_LRFU_LAMBDA.varname, 1.0f);
        EvictionTracker et = new EvictionTracker();
        LowLevelLrfuCachePolicy lru = new LowLevelLrfuCachePolicy(1, (long)heapSize, conf);
        LowLevelCacheMemoryManager mm = new LowLevelCacheMemoryManager((long)heapSize, (LowLevelCachePolicy)lru, LlapDaemonCacheMetrics.create((String)"test", (String)"1"));
        lru.setEvictionListener((EvictionListener)et);
        for (i = 0; i < heapSize; ++i) {
            LlapDataBuffer buffer = LowLevelCacheImpl.allocateFake();
            Assert.assertTrue((boolean)this.cache(mm, lru, et, buffer));
            inserted.add(buffer);
        }
        Collections.shuffle(inserted, rdm);
        for (i = 0; i < inserted.size(); ++i) {
            for (int j = 0; j < inserted.size() - i; ++j) {
                lru.notifyLock((LlapCacheableBuffer)inserted.get(i));
                lru.notifyUnlock((LlapCacheableBuffer)inserted.get(i));
            }
        }
        this.verifyOrder(mm, lru, et, inserted, null);
    }

    @Test
    public void testDeadlockResolution() {
        int heapSize = 4;
        LOG.info("Testing deadlock resolution");
        ArrayList<LlapDataBuffer> inserted = new ArrayList<LlapDataBuffer>(heapSize);
        EvictionTracker et = new EvictionTracker();
        Configuration conf = new Configuration();
        LowLevelLrfuCachePolicy lrfu = new LowLevelLrfuCachePolicy(1, (long)heapSize, conf);
        LowLevelCacheMemoryManager mm = new LowLevelCacheMemoryManager((long)heapSize, (LowLevelCachePolicy)lrfu, LlapDaemonCacheMetrics.create((String)"test", (String)"1"));
        lrfu.setEvictionListener((EvictionListener)et);
        for (int i = 0; i < heapSize; ++i) {
            LlapDataBuffer buffer = LowLevelCacheImpl.allocateFake();
            Assert.assertTrue((boolean)this.cache(mm, lrfu, et, buffer));
            inserted.add(buffer);
        }
        LlapDataBuffer locked = (LlapDataBuffer)inserted.get(0);
        TestLowLevelLrfuCachePolicy.lock(lrfu, locked);
        mm.reserveMemory(1L, false);
        LlapDataBuffer evicted = et.evicted.get(0);
        Assert.assertNotNull((Object)evicted);
        Assert.assertTrue((boolean)evicted.isInvalid());
        Assert.assertNotSame((Object)locked, (Object)evicted);
        TestLowLevelLrfuCachePolicy.unlock(lrfu, locked);
    }

    public boolean cache(LowLevelCacheMemoryManager mm, LowLevelLrfuCachePolicy lrfu, EvictionTracker et, LlapDataBuffer buffer) {
        if (mm != null && !mm.reserveMemory(1L, false)) {
            return false;
        }
        buffer.incRef();
        lrfu.cache((LlapCacheableBuffer)buffer, LowLevelCache.Priority.NORMAL);
        buffer.decRef();
        lrfu.notifyUnlock((LlapCacheableBuffer)buffer);
        return true;
    }

    private LlapDataBuffer getOneEvictedBuffer(EvictionTracker et) {
        Assert.assertTrue((et.evicted.size() == 0 || et.evicted.size() == 1 ? 1 : 0) != 0);
        LlapDataBuffer result = et.evicted.isEmpty() ? null : et.evicted.get(0);
        et.evicted.clear();
        return result;
    }

    private static void lock(LowLevelLrfuCachePolicy lrfu, LlapDataBuffer locked) {
        locked.incRef();
        lrfu.notifyLock((LlapCacheableBuffer)locked);
    }

    private static void unlock(LowLevelLrfuCachePolicy lrfu, LlapDataBuffer locked) {
        locked.decRef();
        lrfu.notifyUnlock((LlapCacheableBuffer)locked);
    }

    private MetricsMock createMetricsMock() {
        LlapDaemonCacheMetrics metricsMock = (LlapDaemonCacheMetrics)Mockito.mock(LlapDaemonCacheMetrics.class);
        final AtomicLong cacheUsed = new AtomicLong(0L);
        ((LlapDaemonCacheMetrics)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                cacheUsed.addAndGet((Long)invocation.getArguments()[0]);
                return null;
            }
        }).when((Object)metricsMock)).incrCacheCapacityUsed(Matchers.anyLong());
        return new MetricsMock(cacheUsed, metricsMock);
    }

    private void testHeapSize(int heapSize) {
        LOG.info("Testing heap size " + heapSize);
        Random rdm = new Random(1234L);
        Configuration conf = new Configuration();
        conf.setFloat(HiveConf.ConfVars.LLAP_LRFU_LAMBDA.varname, 0.2f);
        EvictionTracker et = new EvictionTracker();
        LowLevelLrfuCachePolicy lrfu = new LowLevelLrfuCachePolicy(1, (long)heapSize, conf);
        MetricsMock m = this.createMetricsMock();
        LowLevelCacheMemoryManager mm = new LowLevelCacheMemoryManager((long)heapSize, (LowLevelCachePolicy)lrfu, m.metricsMock);
        lrfu.setEvictionListener((EvictionListener)et);
        int toEvict = 2;
        ArrayList<LlapDataBuffer> inserted = new ArrayList<LlapDataBuffer>(heapSize);
        LlapDataBuffer[] evicted = new LlapDataBuffer[toEvict];
        Assume.assumeTrue((toEvict <= heapSize ? 1 : 0) != 0);
        for (int i = 0; i < heapSize + toEvict; ++i) {
            LlapDataBuffer buffer = LowLevelCacheImpl.allocateFake();
            Assert.assertTrue((boolean)this.cache(mm, lrfu, et, buffer));
            Assert.assertEquals((long)Math.min(i + 1, heapSize), (long)m.cacheUsed.get());
            LlapDataBuffer evictedBuf = this.getOneEvictedBuffer(et);
            if (i < toEvict) {
                evicted[i] = buffer;
                continue;
            }
            if (i >= heapSize) {
                Assert.assertSame((Object)evicted[i - heapSize], (Object)evictedBuf);
                Assert.assertTrue((boolean)evictedBuf.isInvalid());
            } else {
                Assert.assertNull((Object)evictedBuf);
            }
            inserted.add(buffer);
        }
        LOG.info("Inserted " + this.dumpInserted(inserted));
        Collections.shuffle(inserted, rdm);
        LOG.info("Touch order " + this.dumpInserted(inserted));
        for (LlapDataBuffer buf : inserted) {
            TestLowLevelLrfuCachePolicy.lock(lrfu, buf);
        }
        Assert.assertEquals((long)heapSize, (long)m.cacheUsed.get());
        Assert.assertFalse((boolean)mm.reserveMemory(1L, false));
        if (!et.evicted.isEmpty()) {
            Assert.assertTrue((String)("Got " + et.evicted.get(0)), (boolean)et.evicted.isEmpty());
        }
        for (LlapDataBuffer buf : inserted) {
            TestLowLevelLrfuCachePolicy.unlock(lrfu, buf);
        }
        for (LlapDataBuffer buf : inserted) {
            for (int j = 0; j < 10; ++j) {
                lrfu.notifyLock((LlapCacheableBuffer)buf);
                lrfu.notifyUnlock((LlapCacheableBuffer)buf);
            }
        }
        this.verifyOrder(mm, lrfu, et, inserted, m.cacheUsed);
    }

    private void verifyOrder(LowLevelCacheMemoryManager mm, LowLevelLrfuCachePolicy lrfu, EvictionTracker et, ArrayList<LlapDataBuffer> inserted, AtomicLong cacheUsed) {
        int i;
        et.evicted.clear();
        for (i = 0; i < inserted.size(); ++i) {
            Assert.assertTrue((boolean)mm.reserveMemory(1L, false));
            if (cacheUsed == null) continue;
            Assert.assertEquals((long)inserted.size(), (long)cacheUsed.get());
        }
        Assert.assertFalse((boolean)mm.reserveMemory(1L, false));
        if (cacheUsed != null) {
            Assert.assertEquals((long)inserted.size(), (long)cacheUsed.get());
        }
        for (i = 0; i < inserted.size(); ++i) {
            LlapDataBuffer block = et.evicted.get(i);
            Assert.assertTrue((boolean)block.isInvalid());
            Assert.assertSame((Object)inserted.get(i), (Object)block);
        }
        if (cacheUsed != null) {
            mm.releaseMemory((long)inserted.size());
            Assert.assertEquals((long)0L, (long)cacheUsed.get());
        }
    }

    private String dumpInserted(ArrayList<LlapDataBuffer> inserted) {
        String debugStr = "";
        for (int i = 0; i < inserted.size(); ++i) {
            if (i != 0) {
                debugStr = debugStr + ", ";
            }
            debugStr = debugStr + inserted.get(i);
        }
        return debugStr;
    }

    private static class MetricsMock {
        public AtomicLong cacheUsed;
        public LlapDaemonCacheMetrics metricsMock;

        public MetricsMock(AtomicLong cacheUsed, LlapDaemonCacheMetrics metricsMock) {
            this.cacheUsed = cacheUsed;
            this.metricsMock = metricsMock;
        }
    }

    private class EvictionTracker
    implements EvictionListener {
        public List<LlapDataBuffer> evicted = new ArrayList<LlapDataBuffer>();

        private EvictionTracker() {
        }

        public void notifyEvicted(LlapCacheableBuffer buffer) {
            this.evicted.add((LlapDataBuffer)buffer);
        }
    }
}

