/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import java.util.Comparator;
import org.apache.hadoop.hive.llap.daemon.impl.EvictingPriorityBlockingQueue;
import org.junit.Assert;
import org.junit.Test;

public class TestEvictingPriorityBlockingQueue {
    @Test(timeout=10000L)
    public void test() throws InterruptedException {
        EvictingPriorityBlockingQueue queue = new EvictingPriorityBlockingQueue((Comparator)new ElementComparator(), 3);
        Element[] elements = new Element[10];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = new Element(i);
        }
        Assert.assertNull((Object)queue.offer((Object)elements[0], 0));
        Assert.assertNull((Object)queue.offer((Object)elements[1], 0));
        Assert.assertNull((Object)queue.offer((Object)elements[2], 0));
        Element e = (Element)queue.offer((Object)elements[3], 0);
        Assert.assertEquals((Object)elements[0], (Object)e);
        e = (Element)queue.offer((Object)elements[0], 0);
        Assert.assertEquals((Object)elements[0], (Object)e);
        e = (Element)queue.offer((Object)elements[4], 0);
        Assert.assertEquals((Object)elements[1], (Object)e);
        e = (Element)queue.offer((Object)elements[1], 1);
        Assert.assertNull((Object)e);
        Assert.assertEquals((long)4L, (long)queue.size());
        e = (Element)queue.take();
        Assert.assertEquals((Object)elements[4], (Object)e);
        e = (Element)queue.offer((Object)elements[4], 1);
        Assert.assertNull((Object)e);
        e = (Element)queue.offer((Object)elements[0], 1);
        Assert.assertEquals((Object)elements[0], (Object)e);
        Assert.assertTrue((boolean)TestEvictingPriorityBlockingQueue.reinsertIfExists(queue, elements[2]));
        Assert.assertEquals((long)4L, (long)queue.size());
        Assert.assertFalse((boolean)TestEvictingPriorityBlockingQueue.reinsertIfExists(queue, elements[5]));
        Assert.assertEquals((long)4L, (long)queue.size());
        e = (Element)queue.offer((Object)elements[5], 1);
        Assert.assertEquals((Object)elements[1], (Object)e);
        Assert.assertNull((Object)queue.offer((Object)elements[1], 2));
        Assert.assertNull((Object)queue.offer((Object)elements[6], 5));
        Assert.assertNull((Object)queue.offer((Object)elements[7], 5));
        Assert.assertEquals((long)7L, (long)queue.size());
    }

    public static <T> boolean reinsertIfExists(EvictingPriorityBlockingQueue<T> queue, T e) {
        if (queue.remove(e)) {
            queue.forceOffer(e);
            return true;
        }
        return false;
    }

    private static class ElementComparator
    implements Comparator<Element> {
        private ElementComparator() {
        }

        @Override
        public int compare(Element o1, Element o2) {
            return o2.x - o1.x;
        }
    }

    private static class Element {
        int x;

        public Element(int x) {
            this.x = x;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Element element = (Element)o;
            return this.x == element.x;
        }

        public int hashCode() {
            return this.x;
        }
    }
}

