/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.llap.daemon.impl.LlapTokenChecker;
import org.apache.hadoop.hive.llap.security.LlapTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestLlapTokenChecker {
    @Test
    public void testGetToken() {
        this.check(LlapTokenChecker.getTokenInfoInternal((String)"u", null), "u", null);
        this.check(LlapTokenChecker.getTokenInfoInternal(null, this.createTokens("u", null)), "u", null);
        this.check(LlapTokenChecker.getTokenInfoInternal(null, this.createTokens("u", "a")), "u", "a");
        this.check(LlapTokenChecker.getTokenInfoInternal((String)"u", this.createTokens("u", "a")), "u", "a");
        this.check(LlapTokenChecker.getTokenInfoInternal((String)"u", this.createTokens("u", "a", "u", null)), "u", "a");
        this.checkGetThrows("u", this.createTokens("u2", "a"));
        this.checkGetThrows("u2", this.createTokens("u2", "a", "u3", "a"));
        this.checkGetThrows(null, this.createTokens("u2", "a", "u3", "a"));
        this.checkGetThrows(null, this.createTokens("u2", "a", "u2", "a1"));
    }

    @Test
    public void testCheckPermissions() {
        LlapTokenChecker.checkPermissionsInternal((String)"u", null, (String)"u", null, null);
        LlapTokenChecker.checkPermissionsInternal(null, this.createTokens("u", null), (String)"u", null, null);
        LlapTokenChecker.checkPermissionsInternal((String)"u", this.createTokens("u", "a"), (String)"u", (String)"a", null);
        this.checkPrmThrows("u2", null, "u", "a");
        this.checkPrmThrows("u", null, "u", "a");
        this.checkPrmThrows(null, this.createTokens("u2", "a"), "u", "a");
        this.checkPrmThrows(null, this.createTokens("u", "a2"), "u", "a");
        this.checkPrmThrows(null, this.createTokens("u", null), "u", "a");
    }

    private List<LlapTokenIdentifier> createTokens(String ... args) {
        ArrayList<LlapTokenIdentifier> tokens = new ArrayList<LlapTokenIdentifier>();
        for (int i = 0; i < args.length; i += 2) {
            tokens.add(new LlapTokenIdentifier(new Text(args[i]), null, null, "c", args[i + 1], false));
        }
        return tokens;
    }

    private void checkGetThrows(String kerberosName, List<LlapTokenIdentifier> tokens) {
        try {
            LlapTokenChecker.getTokenInfoInternal((String)kerberosName, tokens);
            Assert.fail((String)"Didn't throw");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private void checkPrmThrows(String kerberosName, List<LlapTokenIdentifier> tokens, String userName, String appId) {
        try {
            LlapTokenChecker.checkPermissionsInternal((String)kerberosName, tokens, (String)userName, (String)appId, null);
            Assert.fail((String)"Didn't throw");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private void check(LlapTokenChecker.LlapTokenInfo p, String user, String appId) {
        Assert.assertEquals((Object)user, (Object)p.userName);
        Assert.assertEquals((Object)appId, (Object)p.appId);
    }
}

