/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl.comparator;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.DaemonId;
import org.apache.hadoop.hive.llap.daemon.QueryFailedHandler;
import org.apache.hadoop.hive.llap.daemon.impl.AMReporter;
import org.apache.hadoop.hive.llap.daemon.impl.QueryIdentifier;
import org.apache.hadoop.hive.llap.protocol.LlapTaskUmbilicalProtocol;
import org.apache.hadoop.io.Text;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestAMReporter {
    @Test(timeout=5000L)
    public void testMultipleAM() throws InterruptedException {
        int numExecutors = 1;
        int maxThreads = 1;
        AtomicReference<InetSocketAddress> localAddress = new AtomicReference<InetSocketAddress>(new InetSocketAddress(12345));
        QueryFailedHandler queryFailedHandler = (QueryFailedHandler)Mockito.mock(QueryFailedHandler.class);
        Configuration conf = new Configuration();
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_AM_LIVENESS_HEARTBEAT_INTERVAL_MS, (String)"100ms");
        DaemonId daemonId = (DaemonId)Mockito.mock(DaemonId.class);
        Mockito.when((Object)daemonId.getUniqueNodeIdInCluster()).thenReturn((Object)"nodeId");
        SocketFactory socketFactory = (SocketFactory)Mockito.mock(SocketFactory.class);
        AMReporterForTest amReporter = new AMReporterForTest(numExecutors, maxThreads, localAddress, queryFailedHandler, conf, daemonId, socketFactory);
        amReporter.init(conf);
        amReporter.start();
        int am1Port = 123;
        int am2Port = 456;
        String am1Location = "am1";
        String am2Location = "am2";
        String umbilicalUser = "user";
        QueryIdentifier queryId = new QueryIdentifier("app", 0);
        amReporter.registerTask(am1Location, am1Port, umbilicalUser, null, queryId, (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class), false);
        amReporter.registerTask(am2Location, am2Port, umbilicalUser, null, queryId, (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class), false);
        Thread.currentThread();
        Thread.sleep(2000L);
        Assert.assertEquals((long)2L, (long)amReporter.heartbeatedHost.size());
        amReporter.stop();
    }

    class AMReporterForTest
    extends AMReporter {
        Set<AMReporter.AMNodeInfo> heartbeatedHost;

        public AMReporterForTest(int numExecutors, int maxThreads, AtomicReference<InetSocketAddress> localAddress, QueryFailedHandler queryFailedHandler, Configuration conf, DaemonId daemonId, SocketFactory socketFactory) {
            super(numExecutors, maxThreads, localAddress, queryFailedHandler, conf, daemonId, socketFactory);
            this.heartbeatedHost = new HashSet<AMReporter.AMNodeInfo>();
        }

        protected LlapTaskUmbilicalProtocol createUmbilical(final AMReporter.AMNodeInfo amNodeInfo) throws IOException {
            LlapTaskUmbilicalProtocol umbilical = (LlapTaskUmbilicalProtocol)Mockito.mock(LlapTaskUmbilicalProtocol.class);
            ((LlapTaskUmbilicalProtocol)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                    AMReporterForTest.this.heartbeatedHost.add(amNodeInfo);
                    return null;
                }
            }).when((Object)umbilical)).nodeHeartbeat((Text)Matchers.any(Text.class), (Text)Matchers.any(Text.class), Matchers.anyInt(), (LlapTaskUmbilicalProtocol.TezAttemptArray)Matchers.any(LlapTaskUmbilicalProtocol.TezAttemptArray.class), (LlapTaskUmbilicalProtocol.BooleanArray)Matchers.any(LlapTaskUmbilicalProtocol.BooleanArray.class));
            return umbilical;
        }
    }
}

