/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cli.LlapStatusServiceDriver;
import org.apache.hadoop.hive.llap.cli.status.LlapStatusHelpers;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.slider.api.types.ApplicationDiagnostics;
import org.apache.slider.client.SliderClient;
import org.apache.slider.common.params.ActionCreateArgs;
import org.apache.slider.common.params.ActionDestroyArgs;
import org.apache.slider.common.params.ActionFreezeArgs;
import org.apache.slider.common.params.ActionInstallPackageArgs;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.exceptions.UnknownApplicationInstanceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapSliderUtils {
    private static final String SLIDER_GZ = "slider-agent.tar.gz";
    private static final Logger LOG = LoggerFactory.getLogger(LlapSliderUtils.class);

    public static SliderClient createSliderClient(Configuration conf) throws Exception {
        SliderClient sliderClient = new SliderClient(){

            public void serviceInit(Configuration conf) throws Exception {
                super.serviceInit(conf);
                this.initHadoopBinding();
            }
        };
        Configuration sliderClientConf = new Configuration(conf);
        sliderClientConf = sliderClient.bindArgs(sliderClientConf, new String[]{"help"});
        sliderClient.init(sliderClientConf);
        sliderClient.start();
        return sliderClient;
    }

    public static ApplicationReport getAppReport(String appName, SliderClient sliderClient, long timeoutMs) throws LlapStatusServiceDriver.LlapStatusCliException {
        SystemClock clock = new SystemClock();
        long startTime = clock.getTime();
        long timeoutTime = timeoutMs < 0L ? Long.MAX_VALUE : startTime + timeoutMs;
        ApplicationReport appReport = null;
        while (appReport == null) {
            try {
                appReport = sliderClient.getYarnAppListClient().findInstance(appName);
                if (timeoutMs == 0L) break;
                if (appReport != null) continue;
                long remainingTime = Math.min(timeoutTime - clock.getTime(), 500L);
                if (remainingTime <= 0L) break;
                Thread.sleep(remainingTime);
            }
            catch (Exception e) {
                throw new LlapStatusServiceDriver.LlapStatusCliException(LlapStatusServiceDriver.ExitCode.YARN_ERROR, "Failed to get Yarn AppReport", e);
            }
        }
        return appReport;
    }

    public static ApplicationDiagnostics getApplicationDiagnosticsFromYarnDiagnostics(ApplicationReport appReport, LlapStatusHelpers.AppStatusBuilder appStatusBuilder, Logger LOG) {
        if (appReport == null) {
            return null;
        }
        String diagnostics = appReport.getDiagnostics();
        if (diagnostics == null || diagnostics.isEmpty()) {
            return null;
        }
        try {
            return ApplicationDiagnostics.fromJson((String)diagnostics);
        }
        catch (IOException e) {
            LOG.warn("Failed to parse application diagnostics from Yarn Diagnostics - {}", (Object)diagnostics);
            appStatusBuilder.setDiagnostics(diagnostics);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startCluster(Configuration conf, String name, String packageName, Path packageDir, String queue) {
        SliderClient sc;
        LOG.info("Starting cluster with " + name + ", " + packageName + ", " + queue + ", " + packageDir);
        try {
            sc = LlapSliderUtils.createSliderClient(conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            LOG.info("Executing the freeze command");
            ActionFreezeArgs freezeArgs = new ActionFreezeArgs();
            freezeArgs.force = true;
            freezeArgs.setWaittime(3600);
            try {
                sc.actionFreeze(name, freezeArgs);
            }
            catch (UnknownApplicationInstanceException ex) {
                LOG.info("There was no old application instance to freeze");
            }
            LOG.info("Executing the destroy command");
            ActionDestroyArgs destroyArg = new ActionDestroyArgs();
            destroyArg.force = true;
            try {
                sc.actionDestroy(name, destroyArg);
            }
            catch (UnknownApplicationInstanceException ex) {
                LOG.info("There was no old application instance to destroy");
            }
            LOG.info("Executing the install command");
            ActionInstallPackageArgs installArgs = new ActionInstallPackageArgs();
            installArgs.name = "LLAP";
            installArgs.packageURI = new Path(packageDir, packageName).toString();
            installArgs.replacePkg = true;
            sc.actionInstallPkg(installArgs);
            LOG.info("Executing the create command");
            ActionCreateArgs createArgs = new ActionCreateArgs();
            createArgs.resources = new File(new Path(packageDir, "resources.json").toString());
            createArgs.template = new File(new Path(packageDir, "appConfig.json").toString());
            createArgs.setWaittime(3600);
            if (queue != null) {
                createArgs.queue = queue;
            }
            File bogusSliderFile = LlapSliderUtils.startSetSliderLibDir();
            try {
                sc.actionCreate(name, createArgs);
            }
            finally {
                LlapSliderUtils.endSetSliderLibDir(bogusSliderFile);
            }
            LOG.debug("Started the cluster via slider API");
        }
        catch (IOException | YarnException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                sc.close();
            }
            catch (IOException e) {
                LOG.info("Failed to close slider client", (Throwable)e);
            }
        }
    }

    public static File startSetSliderLibDir() throws IOException {
        File rootDir;
        File sliderJarDir2;
        File sliderJarDir = SliderUtils.findContainingJar(SliderClient.class).getParentFile();
        File gz = new File(sliderJarDir, SLIDER_GZ);
        if (gz.exists()) {
            String path = sliderJarDir.getAbsolutePath();
            LOG.info("Setting slider.libdir based on jar file location: " + path);
            System.setProperty("slider.libdir", path);
            return null;
        }
        String path = System.getProperty("slider.libdir");
        gz = null;
        if (path != null && !path.isEmpty()) {
            LOG.info("slider.libdir was already set: " + path);
            gz = new File(path, SLIDER_GZ);
            if (!gz.exists()) {
                gz = null;
            }
        }
        if (gz == null && (path = System.getenv("SLIDER_HOME")) != null && !path.isEmpty()) {
            gz = new File(new File(path, "lib"), SLIDER_GZ);
            if (gz.exists()) {
                path = gz.getParentFile().getAbsolutePath();
                LOG.info("Setting slider.libdir based on SLIDER_HOME: " + path);
                System.setProperty("slider.libdir", path);
            } else {
                gz = null;
            }
        }
        if (gz == null && (sliderJarDir2 = new File(new File(rootDir = SliderUtils.findContainingJar(HiveConf.class).getParentFile().getParentFile().getParentFile(), "slider"), "lib")).exists()) {
            gz = new File(sliderJarDir2, SLIDER_GZ);
            if (gz.exists()) {
                path = sliderJarDir2.getAbsolutePath();
                LOG.info("Setting slider.libdir based on guesswork: " + path);
                System.setProperty("slider.libdir", path);
            } else {
                gz = null;
            }
        }
        if (gz == null) {
            throw new IOException("Cannot find slider-agent.tar.gz. Please ensure SLIDER_HOME is set.");
        }
        File newGz = new File(sliderJarDir, SLIDER_GZ);
        LOG.info("Copying " + gz + " to " + newGz);
        Files.copy((File)gz, (File)newGz);
        newGz.deleteOnExit();
        return newGz;
    }

    public static void endSetSliderLibDir(File newGz) throws IOException {
        if (newGz == null || !newGz.exists()) {
            return;
        }
        LOG.info("Deleting " + newGz);
        newGz.delete();
    }
}

