/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.security;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.UgiFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.UserGroupInformation;

public class LlapUgiFactoryFactory {
    private static final HadoopShims SHIMS = ShimLoader.getHadoopShims();

    public static UgiFactory createFsUgiFactory(Configuration conf) throws IOException {
        boolean hasFsPrincipal;
        String fsKeytab = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_FS_KERBEROS_KEYTAB_FILE);
        String fsPrincipal = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_FS_KERBEROS_PRINCIPAL);
        boolean hasFsKeytab = fsKeytab != null && !fsKeytab.isEmpty();
        boolean bl = hasFsPrincipal = fsPrincipal != null && !fsPrincipal.isEmpty();
        if (hasFsKeytab != hasFsPrincipal) {
            throw new IOException("Inconsistent FS keytab settings " + fsKeytab + "; " + fsPrincipal);
        }
        boolean hopsTLS = conf.getBoolean("ipc.server.ssl.enabled", false);
        if (hasFsKeytab) {
            return new KerberosUgiFactory(fsKeytab, fsPrincipal);
        }
        if (hopsTLS) {
            return new CurrentUgiFactory();
        }
        return new NoopUgiFactory();
    }

    private static class CurrentUgiFactory
    implements UgiFactory {
        private CurrentUgiFactory() {
        }

        public UserGroupInformation createUgi() throws IOException {
            return UserGroupInformation.getCurrentUser();
        }
    }

    private static class NoopUgiFactory
    implements UgiFactory {
        private NoopUgiFactory() {
        }

        public UserGroupInformation createUgi() throws IOException {
            return null;
        }
    }

    private static class KerberosUgiFactory
    implements UgiFactory {
        private final UserGroupInformation baseUgi;

        public KerberosUgiFactory(String keytab, String principal) throws IOException {
            this.baseUgi = LlapUtil.loginWithKerberos((String)principal, (String)keytab);
        }

        public UserGroupInformation createUgi() throws IOException {
            this.baseUgi.checkTGTAndReloginFromKeytab();
            return SHIMS.cloneUgi(this.baseUgi);
        }
    }
}

